import QtQuick 1.0

Rectangle {
    id: rectangle1
    width: 311
    height: 129

    function setText(mhz, khz) {
        mhText.text = mhz
        khText.text = khz
    }

    gradient: Gradient {
        GradientStop { position: 0; color: "#33000000" }
        GradientStop { position: 0.3; color: "#33dddddd" }
        GradientStop { position: 0.99; color: "#33000000" }
    }

    Text {
        id: mhText
        x: 53
        text: "88"
        anchors.top: point.bottom
        anchors.topMargin: -73
        font.pixelSize: 99
        color: "white"
        font.family: "digital-7"
        verticalAlignment: Text.AlignTop
        anchors.right: point.left
        anchors.rightMargin: -1
        horizontalAlignment: Text.AlignRight
    }

    Text {
        id: khText
        text: "500"
        color: "white"
        font.family: "digital-7"
        anchors.top: point.bottom
        anchors.topMargin: -36
        z: 0
        scale: 1
        transformOrigin: Item.Center
        anchors.left: point.right
        anchors.leftMargin: 0
        verticalAlignment: Text.AlignBottom
        horizontalAlignment: Text.AlignRight
        font.pixelSize: 48
    }

    Text {
        id: point
        x: 148
        y: 28
        text: "."
        color: "white"
        font.family: "digital-7"
        font.pixelSize: 99
    }

    Text {
        id: mhSimble
        x: 247
        y: 76
        text: "Mhz"
        font.family: "digital-7"
        color: "cyan"
        font.pixelSize: 33
    }
}
