TEMPLATE = lib 
TARGET = vk
CONFIG += qtopiamail messageserver plugin debug link_pkgconfig
QT = core network

#Depends on
# libxml - http://xmlsoft.org/downloads.html
# glib - http://www.gtk.org/download.html
# libvkontakte - http://www.gitorious.org/mysocials/libvkontakte
PKGCONFIG += libxml-2.0 glib-2.0 libvkontakte

# message(Qt $$[QT_VERSION] is installed in $$[QT_INSTALL_PREFIX])

# include private developer settings
exists(../devel.pri) {
    include(../devel.pri)
}

isEmpty(QMF_INSTALL_ROOT) {
    QMF_INSTALL_ROOT = /usr/local
}

# if exists path to plugins (not variable)
exists($$(QMF_PLUGINS)) {
#    message(Was added QMF_PLUGINS: $$(QMF_PLUGINS))
#    message(Plugin will be installed to $(QMF_PLUGINS)/messageservices)
    target.path = $$(QMF_PLUGINS)/messageservices
} else {
#    message(Plugin will be installed to $$QMF_INSTALL_ROOT/plugins/messageservices)
    target.path = $$QMF_INSTALL_ROOT/plugins/messageservices
}

exists($$(QMF_INCLUDEDIR)) {
#    message(Was added QMF_INCLUDEDIR: $$(QMF_INCLUDEDIR))
    INCLUDEPATH += $$(QMF_INCLUDEDIR)
}

exists($$(QMF_LIBDIR)) {
#    message(Was added QMF_LIBDIR: $$(QMF_LIBDIR))
    LIBS += -L $$(QMF_LIBDIR) -lqtopiamail
    QMAKE_RPATHDIR+= $$(QMF_LIBDIR)
}


DEPENDPATH += .

INCLUDEPATH += . \
               $$QMF_INSTALL_ROOT/include/qtopiamail \
               $$QMF_INSTALL_ROOT/include/messageserver

LIBS += -L$$QMF_INSTALL_ROOT/lib
macx:LIBS += -F$$QMF_INSTALL_ROOT/lib


HEADERS += vkclient.h \
           vkconfiguration.h \
           vkservice.h \
           vktransport.h

SOURCES += vkclient.cpp \
           vkconfiguration.cpp \
           vkservice.cpp \
           vktransport.cpp

!contains(DEFINES,QMF_NO_MESSAGE_SERVICE_EDITOR) {
QT += gui

HEADERS += \
           vksettingssource.h \
           vksettingssink.h

FORMS += \
         vksettingssource.ui \
         vksettingssink.ui

SOURCES += \
           vksettingssource.cpp \
           vksettingssink.cpp
}

CONFIG(debug,debug|release) {
    DEFINES += QMF_ENABLE_LOGGING
}

INSTALLS += target

include(../common.pri)

plugin {
    DEFINES += PLUGIN_INTERNAL
}

qtopiamail:qtAddLibrary(qtopiamail)
messageserver:qtAddLibrary(messageserver)
qmfutil:qtAddLibrary(qmfutil)






