/*******************************************************************************
**
** vkclient.h - high level interface. Based on the transfer of objects.
** This file is part of the QMF-Vkontakte plug-in.
**
** Copyright (C) 2010 PetrSU. Pavel Shiryaev <shiryaev AT cs.karelia.ru>
** Contact: QMF-vkontakte team (qmf-vkontakte AT cs.karelia.ru)
**
** QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** QMF-Vkontakte plug-in is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with QMF-Vkontakte plug-in; if not, write to the Free Software
** Foundation, Inc., 51 Franklin St, Fifth Floor,
** Boston, MA  02110-1301  USA
**
*******************************************************************************/

#ifndef VKCLIENT_H
#define VKCLIENT_H

#include <qstring.h>
#include <qstringlist.h>
#include <qobject.h>
#include <qlist.h>
#include <qtimer.h>
#include <qmailaccountconfiguration.h>
#include <qmailmessage.h>
#include <qmailmessageclassifier.h>
#include <qmailmessageserver.h>

#include "vktransport.h"

class QMailAccount;

typedef QMap<QString, QMailMessageId> SelectionMap;

struct RawEmail
{
    QList<QMailAddress> errSent;
    QList<QMailAddress> needSent;
    QMailMessage mail;
};

class VkClient : public QObject
{
    Q_OBJECT

public:
    VkClient(QObject* parent);
    ~VkClient();

    enum TransferStatus
    {
        Init, Auth, SendMessage,
        DeleteMessage, ReadMessage,
        ExportUpdates, UpdateProfile,
        Done, Error, Quit, Exit
    };

    QMailMessage::MessageType messageType() const;

    void setAccount(const QMailAccountId &accountId);
    QMailAccountId account() const;

    void newConnection();
    void getUserName();
    void saveCaptcha(QByteArray code, QByteArray img);
    void removeCaptcha();
    void closeConnection();
    void setOperation(QMailRetrievalAction::RetrievalSpecification spec);
    void setOperation(VkClient::TransferStatus _status);

    void setSelectedMails(const SelectionMap& data);
    void checkForNewMessages();
    void cancelTransfer(QMailServiceAction::Status::ErrorCode code, const QString &text);
    QMailServiceAction::Status::ErrorCode addMail(const QMailMessage& mail);

signals:
    void getInbox(int, int);
    void getSend(int, int);
    void sendNextSignal();
    void delNextSignal();
    void errorOccurred(int, const QString &);
    void errorOccurred(QMailServiceAction::Status::ErrorCode, const QString &);
    void updateStatus(const QString &);
    void messageActionCompleted(const QString &uid);
    void progressChanged(uint, uint);
    void retrievalCompleted();
    void allMessagesReceived();
    void messageTransmitted(QMailMessageId);
    void sendCompleted();

public slots:
    void updateProfile();

protected slots:
    void transportError(int, QString msg);
    void sendNext();
    void delNext();
    void processResponse(VkResponse* response);
    void createMail(QMailMessage *message);

private:
    inline void markAsRead() const;
    inline void setProgress(uint current, uint total);
    inline bool getSystemProxy(QString &proxy, uint &port) const;
    void retrieveOperationCompleted();
    void messageProcessed(const QString &uid);
    void operationFailed(int code, const QString &text);
    void operationFailed(QMailServiceAction::Status::ErrorCode code,
                         const QString &text);

    // Config uses for getting settings of account.
    QMailAccountConfiguration config;

    // Id of folder for inbox messages
    QMailFolderId folderIdInbox;

    // Id of folder for outbox messages
    QMailFolderId folderIdOutbox;

    // Count of messages that will be loaded at once.
    int messagesAtOnce;

    // Current status of plugin
    TransferStatus status;

    // Can we agregate captcha and error to status variable?
    bool error;
    bool captcha;

    SelectionMap selectionMap;
    SelectionMap::ConstIterator selectionItr;

    VkTransport *vkTransport;

    QString retrieveUid;

    // Used in Sink methods
    QList<RawEmail> mailList;
    QList<RawEmail>::Iterator mailItr;
    QList<QMailMessage::MessageChunk> mailChunks;
    QMailMessageId sendingId;

    // Will be used in progress for sending messages
    uint messageLength;
    uint sentLength;
    int outstandingResponses;
    QStringList::Iterator it;
    typedef QMap<QMailMessageId, uint> SendMap;
    SendMap sendSize;
    uint progressSendSize;
    uint totalSendSize;
};

#endif
