/*
 * qorientationcapability_p.h
 * author: Timo Härkönen
 */


#ifndef QORIENTATIONCAPABILITY_P_H
#define QORIENTATIONCAPABILITY_P_H

#include "qorientationcapability.h"
#include "qxfunctions.h"

#include <mce/mode-names.h>
#include <mce/dbus-names.h>

#include <QtDBus>

const QString PORTRAIT_MODE_REQUEST = "_HILDON_PORTRAIT_MODE_REQUEST";
const QString PORTRAIT_MODE_SUPPORT = "_HILDON_PORTRAIT_MODE_SUPPORT";

class QWidget;

namespace Maemo {

class QOrientationCapability;

class QOrientationCapabilityPrivate
{
    MAEMO_DECLARE_PUBLIC(QOrientationCapability);

public:
    QOrientationCapabilityPrivate();
    ~QOrientationCapabilityPrivate();

    inline bool islisteningOrientationChanges() const;
    void setListeningOrientationChanges(bool listening);

    inline QOrientation currentOrientation() const;
    void setOrientation(QOrientation orientation);
    void enablePortraitModeSupport(bool enabled);

private:
    void orientationUpdate(const QString& orientation, const QString& stand, const QString& face);
    void enableAccelerometer();
    void disableAccelerometer();

private:
    bool m_listenForOrientationChanges;
    QOrientation m_currentOrientation;
};

/* begin private class implementation */

QOrientationCapabilityPrivate::QOrientationCapabilityPrivate()
{
    /*
    // Update current orientation to portrait/landscape if desired
    if (updateCurrentOrientation)
    {
        enableAccelerometer();

        // Query current device orientation to start in correct mode
        QDBusMessage msg = QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                                          MCE_REQUEST_IF, MCE_DEVICE_ORIENTATION_GET);

        // Ignore the last three arguments of the orientation information (x, y and z axis)
        QDBusConnection::systemBus().callWithCallback(msg, pub, SLOT(orientationUpdate(QString, QString, QString)));
    }
    */
}

QOrientationCapabilityPrivate::~QOrientationCapabilityPrivate()
{
    MAEMO_PUBLIC(QOrientationCapability);
    Maemo::setIntXProperty(qobject_cast<QWidget *>(pub->parent()), PORTRAIT_MODE_SUPPORT, 0);

    //request to stop accelerometer
    if(m_listenForOrientationChanges) {
        disableAccelerometer();
    }
}

bool QOrientationCapabilityPrivate::islisteningOrientationChanges() const
{
    return m_listenForOrientationChanges;
}

void QOrientationCapabilityPrivate::setListeningOrientationChanges(bool listening)
{
    MAEMO_PUBLIC(QOrientationCapability);

    if (listening)
    {   
        enableAccelerometer();

        QDBusConnection::systemBus().connect("", MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
            MCE_DEVICE_ORIENTATION_SIG, pub, SLOT(orientationUpdate(QString, QString, QString)));
    }
    else
    {
        QDBusConnection::systemBus().disconnect("", MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
            MCE_DEVICE_ORIENTATION_SIG, pub, SLOT(orientationUpdate(QString,QString,QString)));

        disableAccelerometer();
    }

    m_listenForOrientationChanges = listening;
}

void QOrientationCapabilityPrivate::orientationUpdate(const QString& orientation, const QString& /* stand */, const QString& /* face */)
{
    if (orientation == MCE_ORIENTATION_PORTRAIT)
    {
        setOrientation(Portrait);
    }
    else if (orientation == MCE_ORIENTATION_LANDSCAPE)
    {
        setOrientation(Landscape);
    }
}

void QOrientationCapabilityPrivate::setOrientation(QOrientation orientation)
{
    if (orientation != m_currentOrientation)
    {
        MAEMO_PUBLIC(QOrientationCapability);

        if (orientation == Landscape)
        {
            Maemo::setIntXProperty(qobject_cast<QWidget *>(pub->parent()), PORTRAIT_MODE_REQUEST, 0);
        }
        else
        {
            Maemo::setIntXProperty(qobject_cast<QWidget *>(pub->parent()), PORTRAIT_MODE_REQUEST, 1);
        }

        m_currentOrientation = orientation;

        emit pub->orientationChanged(m_currentOrientation);

    }
}

QOrientation QOrientationCapabilityPrivate::currentOrientation() const
{
    return m_currentOrientation;
}

void QOrientationCapabilityPrivate::enableAccelerometer()
{
    QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                                                     MCE_REQUEST_IF, MCE_ACCELEROMETER_ENABLE_REQ));
}

void QOrientationCapabilityPrivate::disableAccelerometer()
{
    QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH,
                                                                         MCE_REQUEST_IF, MCE_ACCELEROMETER_DISABLE_REQ));
}

void QOrientationCapabilityPrivate::enablePortraitModeSupport(bool enabled)
{
    MAEMO_PUBLIC(QOrientationCapability);

    if(enabled) {
        // Set application to support portrait mode
        Maemo::setIntXProperty(qobject_cast<QWidget *>(pub->parent()), PORTRAIT_MODE_SUPPORT, 1);
    }
    else {
        // Disable portrait mode support
        Maemo::setIntXProperty(qobject_cast<QWidget *>(pub->parent()), PORTRAIT_MODE_SUPPORT, 1);
    }
}

} //namespace
#endif


