/*
 * qorientationcapability.cpp
 * author: Timo Härkönen
 */

#include "qorientationcapability.h"
#include "qorientationcapability_p.h"
#include "moc_qorientationcapability.cpp"

#include <QtGui/QWidget>
#include <QtCore>

namespace Maemo {

class QOrientationCapabilityPrivate;

QOrientationCapability::QOrientationCapability(QWidget* parent, bool automaticOrientationUpdate):
        QObject(parent)
{
    MAEMO_INITIALIZE(QOrientationCapability);

    priv->enablePortraitModeSupport(true);
    priv->setListeningOrientationChanges(automaticOrientationUpdate);
}

QOrientationCapability::~QOrientationCapability()
{
    MAEMO_UNINITIALIZE(QOrientationCapability);
}

QOrientation QOrientationCapability::orientation() const
{
    MAEMO_PRIVATE_CONST(QOrientationCapability);
    return priv->currentOrientation();
}

bool QOrientationCapability::isListeningOrientationChanges() const
{
    MAEMO_PRIVATE_CONST(QOrientationCapability);
    return priv->islisteningOrientationChanges();
}

void QOrientationCapability::setListeningForOrientationChanges(bool enabled)
{
    MAEMO_PRIVATE(QOrientationCapability);
    priv->setListeningOrientationChanges(enabled);
}

void QOrientationCapability::setOrientation(QOrientation orientation)
{
    MAEMO_PRIVATE(QOrientationCapability);
    priv->setOrientation(orientation);
}

void QOrientationCapability::orientationUpdate(const QString& orientation, const QString& stand, const QString& face)
{
    MAEMO_PRIVATE(QOrientationCapability);
    priv->orientationUpdate(orientation, stand, face);
}

void QOrientationCapability::enablePortraitModeSupport(bool enabled)
{
    MAEMO_PRIVATE(QOrientationCapability);
    priv->enablePortraitModeSupport(enabled);
}

} //Namespace
