/*
 *  qnotification_p.h
 *  author: Timo Härkönen
 */

#ifndef QNOTIFICATIONS_P_H
#define QNOTIFICATIONS_P_H

#include <QtDBus>

#define __GTK_BINDINGS_H__ //gtkbindings.h:79 has colliding symbol "signal"
extern "C" {
#include <hildon/hildon-banner.h>
}
#undef __GTK_BINDINGS_H__

namespace Maemo {

class QNotifications;

class QNotificationsPrivate
{
    MAEMO_DECLARE_PUBLIC(QNotifications);

public:
    QNotificationsPrivate();
    ~QNotificationsPrivate();
    void showBanner(const QString &text);
    void showSystemNote(const QString &text);
};

/* begin private implementation */

QNotificationsPrivate::QNotificationsPrivate()
{

}

QNotificationsPrivate::~QNotificationsPrivate()
{

}

void QNotificationsPrivate::showBanner(const QString &text)
{
    hildon_banner_show_information(0, "", text.toLatin1());
}

void QNotificationsPrivate::showSystemNote(const QString &text)
{
    QDBusMessage msg = QDBusMessage::createMethodCall("org.freedesktop.Notifications", "/org/freedesktop/Notifications",
                                                                         "org.freedesktop.Notifications", "SystemNoteDialog");

    QList<QVariant> args;
    args.append(text);
    args.append(static_cast<quint32>(0));
    args.append("ok");

    msg.setArguments(args);

    QDBusConnection::systemBus().call(msg);
}

} // namespace

#endif

