/*
 *  qorientationinfo.h
 *  author: Timo Härkönen
 */

#ifndef QORIENTATIONINFO_H
#define QORIENTATIONINFO_H

#include <QObject>
#include "../global/global.h"

namespace Maemo {

class QOrientationInfoPrivate;

class QHILDONSYSTEMCAPABILITIES_SHARED_EXPORT QOrientationInfo : public QObject
{
    Q_OBJECT

    MAEMO_DECLARE_PRIVATE(QOrientationInfo);

public:
    static QOrientationInfo *instance();
    ~QOrientationInfo();
    bool isListening() const;

public Q_SLOTS:
    void startListening();
    void stopListening();

private Q_SLOTS:
    void orientationUpdate(const QString &rotation, const QString &stand, const QString &face, int x, int y, int z);

Q_SIGNALS:
    void orientationChanged(qreal pitch, qreal roll);


private:
    QOrientationInfo(QObject *parent = 0);

    static QOrientationInfo *m_instance;
};

} //namespace
#endif
