/*
    Maemo Orientation Example - mainwindow.cpp

    Author(s):
    Timo Härkönen
*/

#include "mainwindow.h"

#include <QPushButton>
#include <QMenuBar>

using Maemo::Portrait;
using Maemo::Landscape;

MainWindow::MainWindow(QWidget *parent) :
        QMainWindow(parent)
{
    landscape = true;

    orientation = new Maemo::QOrientationCapability(this, false);

    button = new QPushButton(tr("Click to flip screen"), this);

    connect(button, SIGNAL(clicked()), this, SLOT(flip()));

    createActions();
    createMenu();

    setCentralWidget(button);
}

void MainWindow::flip()
{
    if(landscape) {
        orientation->setOrientation(Portrait);
        landscape = false;
    }
    else {
        orientation->setOrientation(Landscape);
        landscape = true;
    }
}

void MainWindow::toggleOrientationChangeMode()
{
    if(orientation->isListeningOrientationChanges()) {
        orientation->setListeningForOrientationChanges(false);
        orientationChangeModeAction->setText(tr("Enable automatic orientation changing"));
        connect(button, SIGNAL(clicked()), this, SLOT(flip()));
        button->setText(tr("Click to flip screen"));
    }
    else {
        orientation->setListeningForOrientationChanges(true);
        orientationChangeModeAction->setText(tr("Disable automatic orientation changing"));
        disconnect(button, SIGNAL(clicked()), this, SLOT(flip()));
        button->setText(tr("Rotate device to flip screen"));
    }
}

void MainWindow::createActions()
{
    quitAction = new QAction(tr("Quit"), this);
    connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));

    orientationChangeModeAction = new QAction(tr("Enable automatic orientation changing"), this);
    connect(orientationChangeModeAction, SIGNAL(triggered()), this, SLOT(toggleOrientationChangeMode()));
}

void MainWindow::createMenu()
{
    menu = menuBar()->addMenu("fremantle");

    menu->addAction(orientationChangeModeAction);
    menu->addAction(quitAction);
}

