/*
    Maemo Orientation Example - mainwindow.cpp

    Author(s):
    Timo Härkönen
*/

#include "mainwindow.h"

#include <QPushButton>
#include <QMenuBar>
#include <QVBoxLayout>
#include <QHBoxLayout>

using Maemo::Portrait;
using Maemo::Landscape;

MainWindow::MainWindow(QWidget *parent) :
        QMainWindow(parent)
{
    landscape = true;

    widget = new QWidget(this);

    orientation = new Maemo::QOrientationCapability(this, false);
    notification = new Maemo::QNotifications(this);

    bannerButton = new QPushButton(tr("Show banner"), this);
    noteButton = new QPushButton(tr("Show note"), this);

    buttonLayout = new QHBoxLayout;
    buttonLayout->addWidget(bannerButton);
    buttonLayout->addWidget(noteButton);

    button = new QPushButton(tr("Flip screen"), this);

    mainLayout = new QVBoxLayout;
    mainLayout->addWidget(button);
    mainLayout->addLayout(buttonLayout);

    widget->setLayout(mainLayout);

    connect(button, SIGNAL(clicked()), this, SLOT(flip()));
    connect(noteButton, SIGNAL(clicked()), this, SLOT(showNote()));
    connect(bannerButton, SIGNAL(clicked()), this, SLOT(showBanner()));

    createActions();
    createMenu();

    setCentralWidget(widget);
}

void MainWindow::flip()
{
    if(landscape) {
        orientation->setOrientation(Portrait);
        landscape = false;
    }
    else {
        orientation->setOrientation(Landscape);
        landscape = true;
    }
}

void MainWindow::toggleOrientationChangeMode()
{
    if(orientation->isListeningOrientationChanges()) {
        orientation->setListeningForOrientationChanges(false);
        orientationChangeModeAction->setText(tr("Enable automatic orientation changing"));
        connect(button, SIGNAL(clicked()), this, SLOT(flip()));
        button->setText(tr("Flip screen"));
    }
    else {
        orientation->setListeningForOrientationChanges(true);
        orientationChangeModeAction->setText(tr("Disable automatic orientation changing"));
        disconnect(button, SIGNAL(clicked()), this, SLOT(flip()));
        button->setText(tr("Rotate device to flip screen"));
    }
}

void MainWindow::createActions()
{
    quitAction = new QAction(tr("Quit"), this);
    connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));

    orientationChangeModeAction = new QAction(tr("Enable automatic orientation changing"), this);
    connect(orientationChangeModeAction, SIGNAL(triggered()), this, SLOT(toggleOrientationChangeMode()));
}

void MainWindow::createMenu()
{
    menu = menuBar()->addMenu("fremantle");

    menu->addAction(orientationChangeModeAction);
    menu->addAction(quitAction);
}

void MainWindow::showNote()
{
    notification->showSystemNote("This is a system note.");
}

void MainWindow::showBanner()
{
    notification->showBanner("This is a Hildon banner.");
}

