/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#include "IKeys.h"
#include "CBacklight.h"
#include <QtGui>

IKeys::IKeys()
{

}


IKeys::~IKeys()
{

}


void IKeys::setupKeys(QWidget * parent)
{
    parent->installEventFilter(parent);
//     qApp->installEventFilter(parent);
}


bool IKeys::eventFilter(QObject *obj, QEvent *event)
{
    if(event->type() == QEvent::KeyPress) {
        int brightness      = CBacklight::self().getBrightness();
        QKeyEvent *keyEvent = static_cast<QKeyEvent *>(event);
        qDebug("Ate key press %x", keyEvent->key());
        qDebug() << obj->objectName();

        if(brightness){
            if(CBacklight::self().getTimeout() != -1) CBacklight::self().toggle();

            switch(keyEvent->key()) {
                case Qt::Key_F9:
                    slotKey1();
                    return true;
                case Qt::Key_F11:
                    slotKey2();
                    return true;
                case Qt::Key_F10:
                    slotKey3();
                    return true;
                case Qt::Key_F12:
                    slotKey4();
                    return true;
                case Qt::Key_Bar:
                    CBacklight::self().toggle();
                    return true;
            }
        }
        else{
            if(keyEvent->key() == Qt::Key_Bar) CBacklight::self().toggle();
        }
        return false;
    }
    return false;
}
