/**********************************************************************************************
    Copyright (C) 2008 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/

#include "CDlgWptIcon.h"
#include "WptIcons.h"
#include "CCanvas.h"

#include <QtGui>

CDlgWptIcon::CDlgWptIcon(QToolButton& button, QWidget * parent)
    : QDialog(parent)
    , button(button)
{
    setupUi(this);
    setWindowFlags(Qt::WindowStaysOnTopHint | Qt::Dialog);
    setAttribute(Qt::WA_DeleteOnClose, false);
    show();

    QString currentIcon = button.objectName();
    QListWidgetItem * currentItem = 0;

    const wpt_icon_t * icon = wptIcons;
    while(icon->name != 0){
        QListWidgetItem * item = new QListWidgetItem(QPixmap(icon->icon),icon->name,listIcons);
        listIcons->addItem(item);
        if(currentIcon == icon->name){
            currentItem = item;
        }
        ++icon;
    }

    if(currentItem){
        listIcons->setCurrentItem(currentItem);
        listIcons->scrollToItem(currentItem);
    }

    connect(listIcons, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(slotIconSelected(QListWidgetItem *)));
}

CDlgWptIcon::~CDlgWptIcon()
{

}

void CDlgWptIcon::slotIconSelected(QListWidgetItem * item)
{
    QSettings cfg;

    cfg.setValue("environment/icon", item->text());

    button.setIcon(item->icon());
    button.setObjectName(item->text());
    accept();
}

