/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#include "CDlgEdit.h"

#include <QtGui>

CDlgEdit::CDlgEdit(QWidget * parent)
: QDialog(parent)
, lineEdit(0)
, textEdit(0)
, singelShift(false)
{
    setupUi(this);
    setWindowFlags(Qt::WindowStaysOnTopHint | Qt::Dialog);
    setAttribute(Qt::WA_DeleteOnClose, false);
    show();


    butShiftDown->setIcon(QPixmap(":/icons/down-16x16.png"));
    butShiftDown2->setIcon(QPixmap(":/icons/down-16x16.png"));
    butShiftDown3->setIcon(QPixmap(":/icons/down-16x16.png"));
    butShiftUp->setIcon(QPixmap(":/icons/up-16x16.png"));
    butShiftUp2->setIcon(QPixmap(":/icons/up-16x16.png"));
    butShiftUp3->setIcon(QPixmap(":/icons/up-16x16.png"));
    butBack->setIcon(QPixmap(":/icons/left-16x16.png"));
    butBack2->setIcon(QPixmap(":/icons/left-16x16.png"));
    butBack3->setIcon(QPixmap(":/icons/left-16x16.png"));

    stackedWidget->setCurrentIndex(eNoCaps);

    qApp->installEventFilter(this);

    hide();

    QList<QToolButton*> keys = findChildren<QToolButton*>(QRegExp("but*"));
    QToolButton * key;
    foreach(key,keys){
        connect(key,SIGNAL(pressed()),this,SLOT(slotKeyPressed()));
        key->setFocusPolicy(Qt::NoFocus);
    }

    connect(butOk, SIGNAL(pressed()), this, SLOT(slotOk()));
    connect(butCancel, SIGNAL(pressed()), this, SLOT(slotCancel()));
    connect(butSpace, SIGNAL(pressed()), this, SLOT(slotSpace()));

}

CDlgEdit::~CDlgEdit()
{

}

bool CDlgEdit::eventFilter(QObject *obj, QEvent *event)
{
    QLineEdit * tmpLineEdit;
    QTextEdit * tmpTextEdit;

    if(event->type() == QEvent::EnterEditFocus && obj != text){

        tmpLineEdit = qobject_cast<QLineEdit*>(obj);
        if(tmpLineEdit){
            lineEdit = tmpLineEdit;
            text->setText(lineEdit->text().trimmed());
            text->setEditFocus(true);

            show();
            return QDialog::eventFilter(obj,event);
        }

        tmpTextEdit = qobject_cast<QTextEdit*>(obj);
        if(tmpTextEdit){
            textEdit = tmpTextEdit;
            text->setText(textEdit->toPlainText());
            text->setEditFocus(true);

            show();
            return QDialog::eventFilter(obj,event);
        }
    }

    return QDialog::eventFilter(obj, event);
}

void CDlgEdit::slotKeyPressed()
{
    QToolButton * key = qobject_cast<QToolButton *>(sender());

    if(key){
        QString name = key->objectName();

        if(name == "butShiftDown" || name == "butShiftDown2"){
            stackedWidget->setCurrentIndex(stackedWidget->currentIndex() == eCapsLock ? eNoCaps : eCapsLock);
        }
        else if(name == "butShiftUp" || name == "butShiftUp2"){
            if(stackedWidget->currentIndex() == eNoCaps){
                stackedWidget->setCurrentIndex(eCapsLock);
                singelShift = true;
            }
        }
        else if(name == "butSym" || name == "butSym2"){
            stackedWidget->setCurrentIndex(eSym);
        }
        else if(name == "butNoCaps"){
            stackedWidget->setCurrentIndex(eNoCaps);
        }
        else if(name == "butBack" || name == "butBack2" || name == "butBack3"){
            QKeyEvent *key = new QKeyEvent(QEvent::KeyPress, Qt::Key_Backspace, Qt::NoModifier,  "", false, 1);
            QApplication::postEvent(text, key);
        }
        else{
            text->insertPlainText(key->text());

            if(singelShift){
                singelShift = false;
                stackedWidget->setCurrentIndex(eNoCaps);
            }
        }

    }
}


void CDlgEdit::slotOk()
{
    if(textEdit){
        textEdit->setText(text->toPlainText());
        textEdit = 0;
    }
    if(lineEdit){
        lineEdit->setText(text->toPlainText());
        lineEdit = 0;
    }

    hide();
}

void CDlgEdit::slotCancel()
{
    textEdit = 0;
    lineEdit = 0;
    hide();
}

void CDlgEdit::slotSpace()
{
    text->insertPlainText(" ");
}
