/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "object.h"
#include "keyboard.h"

#include <qimsyscommandlineargs.h>

#include <QPointer>

using namespace N900::Keyboard;

class Object::Private : private QObject
{
    Q_OBJECT
public:
    Private(Object *parent);
    ~Private();

private slots:
    void enabledChanged(bool enabled);

private:
    Object *q;
    QList< QPointer<Keyboard> > keyboards;
};

Object::Private::Private(Object *parent)
    : QObject(parent)
    , q(parent)
{
    q->setGroups(QStringList() << QLatin1String("X11 Classic"));
    q->setCategoryType(MoreThanOne);
    q->setCategoryName(tr("User Interface/Input Window"));
    q->setName(tr("N900: Virtual Keyboard"));
    q->setAuthor(tr("Tasuku Suzuki"));
    q->setTranslator(tr("None"));

    connect(q, SIGNAL(enabledChanged(bool)), this, SLOT(enabledChanged(bool)), Qt::QueuedConnection);
    enabledChanged(q->isEnabled());
}

Object::Private::~Private()
{
    qDeleteAll(keyboards);
}

void Object::Private::enabledChanged(bool enabled)
{
    keyboards.removeAll(QPointer<Keyboard>());
    if (enabled) {
        QVariant url = QimsysCommandlineArgs::instance()->value("Virtual Keyboard");
        QPointer<Keyboard> keyboard = new Keyboard(q);
        if (url.isNull()) {
            keyboard->setSource(keyboard->resolveUrl("N900/Keyboard/main.qml"));
        } else {
            keyboard->setSource(url.toUrl());
        }
        keyboards.append(keyboard);

        url = QimsysCommandlineArgs::instance()->value("Virtual Keyboard(Sub)");
        if (!url.isNull()) {
            QPointer<Keyboard> keyboard = new Keyboard(q);
            keyboard->setSource(url.toUrl());
            keyboards.append(keyboard);
        }
    } else if (!enabled) {
        qDeleteAll(keyboards);
        keyboards.clear();
    }
}

Object::Object(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

Object::~Object()
{
    delete d;
}

#include "object.moc"
