/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "dbusspyobject.h"

#include <qimsysapplicationmanager.h>
#include <qimsyspreeditmanager.h>
#include <qimsyscandidatemanager.h>
#include <qimsyskeymanager.h>
#include <translator.h>
#include <QSettings>
#include <QDebug>

class DBusSpyObject::Private : private QObject
{
    Q_OBJECT
public:
    Private(DBusSpyObject *parent);
    ~Private();

private slots:
    void enabledChanged(bool enabled);

    // manager
    void focusChanged(bool focus);
    void widgetChanged(qulonglong widget);
    void composingChanged(bool composing);
    void displayLanguageChanged(const QString &displayLanguage);
    void inputLanguageChanged(const QString &inputLanguage);
    void currentIconChanged(const QIcon &currentIcon);
    void triggered(int action);
    void settingsUpdated(const QString &name);

    // preedit
    void itemsChanged(const QimsysPreeditItemList &items);
    void rectChanged(const QRect &rect);
    void fontChanged(const QFont &font);
    void committed(const QString &committedString, qulonglong target);

    // candidates
    void candidatesChanged(const QimsysConversionItemList &candidates);
    void candidatesCurrentIndexChanged(int currentIndex);

private:
    DBusSpyObject *q;
    QimsysApplicationManager manager;
    QimsysPreeditManager preedit;
    QimsysCandidateManager candidates;
};

DBusSpyObject::Private::Private(DBusSpyObject *parent)
    : QObject(parent)
    , q(parent)
{
    QSettings settings;
    settings.beginGroup(q->metaObject()->className());
    // disabled by default
    settings.setValue("Enabled", settings.value("Enabled", false).toBool());

    q->setCategoryType(CanBeNone);
    q->setCategoryName(tr("Debug tools"));

    q->setName(tr("DBus spy for debug"));
    q->setAuthor(tr("Tasuku Suzuki"));
    q->setTranslator(tr("None"));
    connect(q, SIGNAL(enabledChanged(bool)), this, SLOT(enabledChanged(bool)));
    enabledChanged(q->isEnabled());

    manager.init();
    preedit.init();
    candidates.init();
}

DBusSpyObject::Private::~Private()
{
}

void DBusSpyObject::Private::enabledChanged(bool enabled)
{
    if (enabled) {
#define CONNECT( object, func, ... ) \
    connect( &object, SIGNAL(func(__VA_ARGS__)), this, SLOT(func(__VA_ARGS__)) )
#define CONNECT2( object, func, func2, ... ) \
    connect( &object, SIGNAL(func(__VA_ARGS__)), this, SLOT(func2(__VA_ARGS__)) )
        CONNECT(manager, focusChanged, bool);
        CONNECT(manager, widgetChanged, qulonglong);
        CONNECT(manager, composingChanged, bool);
        CONNECT(manager, displayLanguageChanged, QString);
        CONNECT(manager, inputLanguageChanged, QString);
        CONNECT(manager, currentIconChanged, QIcon);
        CONNECT(manager, triggered, int);
        CONNECT(manager, settingsUpdated, QString);
        CONNECT(preedit, itemsChanged, QimsysPreeditItemList);
        CONNECT(preedit, rectChanged, QRect);
        CONNECT(preedit, fontChanged, QFont);
        CONNECT(preedit, committed, QString, qulonglong);
        CONNECT(candidates, candidatesChanged, QimsysConversionItemList);
        CONNECT2(candidates, currentIndexChanged, candidatesCurrentIndexChanged, int);
#undef CONNECT
#undef CONNECT2
    } else {
#define DISCONNECT( object, func, ... ) \
    disconnect( &object, SIGNAL(func(__VA_ARGS__)), this, SLOT(func(__VA_ARGS__)) )
#define DISCONNECT2( object, func, func2, ... ) \
    disconnect( &object, SIGNAL(func(__VA_ARGS__)), this, SLOT(func2(__VA_ARGS__)) )
        DISCONNECT(manager, focusChanged, bool);
        DISCONNECT(manager, widgetChanged, qulonglong);
        DISCONNECT(manager, composingChanged, bool);
        DISCONNECT(manager, displayLanguageChanged, QString);
        DISCONNECT(manager, inputLanguageChanged, QString);
        DISCONNECT(manager, currentIconChanged, QIcon);
        DISCONNECT(manager, triggered, int);
        DISCONNECT(manager, settingsUpdated, QString);
        DISCONNECT(preedit, itemsChanged, QimsysPreeditItemList);
        DISCONNECT(preedit, rectChanged, QRect);
        DISCONNECT(preedit, fontChanged, QFont);
        DISCONNECT(preedit, committed, QString, qulonglong);
        DISCONNECT(candidates, candidatesChanged, QimsysConversionItemList);
        DISCONNECT2(candidates, currentIndexChanged, candidatesCurrentIndexChanged, int);
#undef DISCONNECT
    }
}

#define SLOTS( func, ... ) \
    void DBusSpyObject::Private::func( __VA_ARGS__ )
#define OUTPUT( ... ) \
    { \
        qDebug() << "DBus:" << __FUNCTION__ __VA_ARGS__; \
    }

SLOTS(focusChanged, bool focus) OUTPUT( << focus)
SLOTS(widgetChanged, qulonglong widget) OUTPUT( << widget)
SLOTS(composingChanged, bool composing) OUTPUT( << composing)
SLOTS(displayLanguageChanged, const QString &displayLanguage) OUTPUT( << displayLanguage)
SLOTS(inputLanguageChanged, const QString &inputLanguage) OUTPUT( << inputLanguage)
SLOTS(currentIconChanged, const QIcon &currentIcon) OUTPUT( << currentIcon)
SLOTS(triggered, int action) OUTPUT( << action)
SLOTS(settingsUpdated, const QString &name) OUTPUT( << name)
SLOTS(itemsChanged, const QimsysPreeditItemList &items) OUTPUT( << items)
SLOTS(rectChanged, const QRect &rect) OUTPUT( << rect)
SLOTS(fontChanged, const QFont &font) OUTPUT( << font)
SLOTS(committed, const QString &committedString, qulonglong target) OUTPUT( << committedString << target)
SLOTS(candidatesChanged, const QimsysConversionItemList &candidates) OUTPUT( << candidates)
SLOTS(candidatesCurrentIndexChanged, int currentIndex) OUTPUT( << currentIndex)

#undef SLOTS
#undef OUTPUT

DBusSpyObject::DBusSpyObject(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

DBusSpyObject::~DBusSpyObject()
{
    delete d;
}

#include "dbusspyobject.moc"
