/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "languagesettings.h"
#include "ui_languagesettings.h"
#include "translator.h"
#include "qimsysdebug.h"
#include "qimsysabstractpluginobject.h"
#include "qimsysapplicationmanager.h"

#include <QApplication>
#include <QDir>
#include <QTranslator>
#include <QRadioButton>
#include <QSettings>

class LanguageSettings::Private : private QObject
{
    Q_OBJECT
public:
    Private(QimsysAbstractPluginObject *plugin, LanguageSettings *parent);
    ~Private();

    void save();

private:
    LanguageSettings *q;
    Ui::LanguageSettings ui;
    QMap<QRadioButton*, QString> map;
    QimsysAbstractPluginObject *plugin;
    QimsysApplicationManager manager;
};

LanguageSettings::Private::Private(QimsysAbstractPluginObject *p, LanguageSettings *parent)
    : QObject(parent)
    , q(parent)
    , plugin(p)
{
    manager.init();
    Translator::begin();
    ui.setupUi(q);
    Translator::ui(q);
    Translator::end();

    QString current = manager.displayLanguage();
    QTranslator translator;
    QDir dir(QApplication::applicationDirPath() + QLatin1String("/") + QIMSYS_MACRO_TO_STRING(QIMSYS_TRANSLATIONS_PATH));
    foreach(const QString &qm, dir.entryList(QStringList("*.qm"), QDir::Files, QDir::Name)) {
        if (translator.load(qm, dir.absolutePath())) {
            QString translation = translator.translate(metaObject()->className(), QT_TR_NOOP("English"));
            QRadioButton *radio = new QRadioButton(translation.isEmpty() ? QLatin1String("English") : translation);
            map[radio] =  QFileInfo(qm).baseName().mid(QString("qimsys_").length());
            ui.languages->addWidget(radio);
            radio->setChecked(map[radio] == current);
            radio->show();
        }
    }
    ui.languages->addStretch();
}

LanguageSettings::Private::~Private()
{
}

void LanguageSettings::Private::save()
{
    QSettings settings;
    settings.beginGroup("Application");
    foreach(QRadioButton *radio, map.keys()) {
        if (radio->isChecked()) {
            manager.setDisplayLanguage(map[radio]);
            settings.setValue("Language", map[radio]);
            break;
        }
    }
}

LanguageSettings::LanguageSettings(QimsysAbstractPluginObject *plugin, QWidget *parent)
    : QimsysSettingsWidget(parent)
{
    d = new Private(plugin, this);
}

LanguageSettings::~LanguageSettings()
{
    delete d;
}

void LanguageSettings::save()
{
    d->save();
    QimsysSettingsWidget::save();
}

#include "languagesettings.moc"
