/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <QtTest>
#include <QCoreApplication>

#include "debug.h"

class
            class IMModuleTest : public QObject
    {
        Q_OBJECT
    public:
        IMModuleTest(QObject* parent = 0)
                : QObject(parent)
                , anthy(0) {
            QMap<QString, QString> environment = QProcess::systemEnvironment();

            QDir dir(QCoreApplication::applicationDirPath());
            while (dir.cdUp()) {
//   DEBUG() << dir.dirName();
                foreach(const QString& subdir, dir.entryList(QDir::Dirs)) {
//    DEBUG() << "\t" << subdir;
                    if (dir.exists(QLatin1String("bin/qimsys"))) {
                        dir.cd(QLatin1String("bin"));

                    }
                }
            }
        }

        ~IMModuleTest() {
            delete anthy;
        }

    public slots:
        void initTestCase() {
            QVERIFY(anthy);
        }

        void init() {
        }

        void cleanup() {
        }

    private slots:
        void split_data() {
            QTest::addColumn<QString>("inputString");
            QTest::addColumn<QimsysConversionElementList>("conversions");

            {
                QimsysConversionElementList conversions;
                QimsysConversionElement e;
                e.from = QString::fromUtf8("あいうえお");
                e.to = QString::fromUtf8("アイウエオ");
                conversions.append(e);
                QTest::newRow("abcdef") << QString::fromUtf8("あいうえお") << conversions;
            }

            {
                QimsysConversionElementList conversions;
                {
                    QimsysConversionElement e;
                    e.from = QString::fromUtf8("わたしの");
                    e.to = QString::fromUtf8("私の");
                    conversions.append(e);
                }
                {
                    QimsysConversionElement e;
                    e.from = QString::fromUtf8("なまえは");
                    e.to = QString::fromUtf8("名前は");
                    conversions.append(e);
                }
                {
                    QimsysConversionElement e;
                    e.from = QString::fromUtf8("なかのです");
                    e.to = QString::fromUtf8("中野です");
                    conversions.append(e);
                }
                {
                    QimsysConversionElement e;
                    e.from = QString::fromUtf8("。");
                    e.to = QString::fromUtf8("。");
                    conversions.append(e);
                }
                QTest::newRow("My name is nakano.") << QString::fromUtf8("わたしのなまえはなかのです。") << conversions;
            }
        }

        void split() {
            QFETCH(QString, inputString);
            QFETCH(QimsysConversionElementList, conversions);
            anthy->setInputString(inputString);
            connect(anthy, SIGNAL(conversionsChanged(QimsysConversionElementList)), this, SLOT(conversionsChanged(QimsysConversionElementList)));
            waiting = true;
            expected = qVariantFromValue(conversions);
            anthy->convert();
            wait();
            disconnect(anthy, SIGNAL(conversionsChanged(QimsysConversionElementList)), this, SLOT(conversionsChanged(QimsysConversionElementList)));
        }

    protected slots:
        void conversionsChanged(const QimsysConversionElementList& conversions) {
            QCOMPARE(expected.value<QimsysConversionElementList>(), conversions);
            waiting = false;
        }

    private:
        void wait() {
            QTime timer;
            timer.start();
            while (waiting) {
                QTest::qWait(50);
                if (timer.elapsed() > 250) break;
            }
            QVERIFY(!waiting);
        }
    private:
        QimsysEngine* anthy;
        bool waiting;
        QVariant expected;
    };

QTEST_MAIN(IMModuleTest)
#include "main.moc"
