/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "systemtrayobject.h"
#include "systemtrayicon.h"
#include "systemtraysettings.h"
#include "translator.h"

class SystemTrayObject::Private : private QObject
{
    Q_OBJECT
public:
    Private(SystemTrayObject *parent);
    ~Private();

private slots:
    void enabledChanged(bool enabled);

private:
    SystemTrayObject *q;
    SystemTrayIcon *icon;
};

SystemTrayObject::Private::Private(SystemTrayObject *parent)
    : QObject(parent)
    , q(parent)
    , icon(0)
{
    q->setGroups(QStringList() << QLatin1String("X11 Classic"));
    q->setCategoryType(MoreThanOne);
    TR(q, "categoryName", this, QT_TR_NOOP("User Interface/System Controler"));

    q->setIcon(QIcon(":/systemtrayicon.png"));
    TR(q, "name", this, QT_TR_NOOP("System tray"));
    TR(q, "author", this, QT_TR_NOOP("Tasuku Suzuki"));
    TR(q, "translator", this, QT_TR_NOOP("None"));
    connect(q, SIGNAL(enabledChanged(bool)), this, SLOT(enabledChanged(bool)), Qt::QueuedConnection);
    enabledChanged(q->isEnabled());
}

SystemTrayObject::Private::~Private()
{
}

void SystemTrayObject::Private::enabledChanged(bool enabled)
{
    if (enabled && !icon) {
        icon = new SystemTrayIcon(this);
    } else if (!enabled && icon) {
        delete icon;
        icon = 0;
    }
}

SystemTrayObject::SystemTrayObject(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

SystemTrayObject::~SystemTrayObject()
{
    delete d;
}

QimsysSettingsWidget *SystemTrayObject::settings(const QString &hint, QWidget *parent)
{
    return QimsysAbstractPluginObject::settings(hint, parent);
// return new SystemTraySettings( this, parent );
}

#include "systemtrayobject.moc"
