/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "n900settings.h"
#include "ui_n900settings.h"
#include "qimsysdebug.h"
#include "qimsysabstractpluginobject.h"
#include "translator.h"

#include <QSettings>

class N900Settings::Private : private QObject
{
    Q_OBJECT
public:
    Private(QimsysAbstractPluginObject *object, N900Settings *parent);
    ~Private();

    void save();

private slots:
    void toggled();

private:
    N900Settings *q;
    Ui::N900Settings ui;
    QimsysAbstractPluginObject *plugin;
};

N900Settings::Private::Private(QimsysAbstractPluginObject *object, N900Settings *parent)
    : QObject(parent)
    , q(parent)
    , plugin(object)
{
    Translator::begin();
    ui.setupUi(q);
    Translator::ui(q);
    Translator::end();

    connect(ui.always, SIGNAL(toggled(bool)), this, SLOT(toggled()));
    connect(ui.available, SIGNAL(toggled(bool)), this, SLOT(toggled()));
    connect(ui.active, SIGNAL(toggled(bool)), this, SLOT(toggled()));
    connect(ui.inactive, SIGNAL(toggled(bool)), this, SLOT(toggled()));
    connect(ui.unavailable, SIGNAL(toggled(bool)), this, SLOT(toggled()));

    QSettings settings;
    settings.beginGroup(plugin->metaObject()->className());
    ui.language->setChecked(settings.value("Language", ui.language->isChecked()).toBool());
    ui.languageSpecific->setChecked(settings.value("Language Specific", ui.languageSpecific->isChecked()).toBool());
    ui.engine->setChecked(settings.value("Engine", ui.engine->isChecked()).toBool());
    ui.userDictionary->setChecked(settings.value("User Dictionary", ui.userDictionary->isChecked()).toBool());
    ui.settings->setChecked(settings.value("Settings", ui.settings->isChecked()).toBool());
    ui.active->setChecked(settings.value("Active", ui.active->isChecked()).toBool());
    ui.available->setChecked(settings.value("Available", ui.available->isChecked()).toBool());
    ui.always->setChecked(settings.value("Always", ui.always->isChecked()).toBool());
    ui.unavailable->setChecked(settings.value("Unavailable", ui.unavailable->isChecked()).toBool());
    ui.inactive->setChecked(settings.value("Inactive", ui.inactive->isChecked()).toBool());
    toggled();

    ui.tabWidget->addTab(q->about(plugin, "", ui.tabWidget), "");
    TR(ui.tabWidget, 1, this, QT_TR_NOOP("&About Plugin"));
}

N900Settings::Private::~Private()
{
}

void N900Settings::Private::save()
{
    QSettings settings;
    settings.beginGroup(plugin->metaObject()->className());
    settings.setValue("Language", ui.language->isChecked());
    settings.setValue("Language Specific", ui.languageSpecific->isChecked());
    settings.setValue("Engine", ui.engine->isChecked());
    settings.setValue("User Dictionary", ui.userDictionary->isChecked());
    settings.setValue("Settings", ui.settings->isChecked());
    settings.setValue("Active", ui.active->isChecked());
    settings.setValue("Available", ui.available->isChecked());
    settings.setValue("Always", ui.always->isChecked());
    settings.setValue("Unavailable", ui.unavailable->isChecked());
    settings.setValue("Inactive", ui.inactive->isChecked());
}

void N900Settings::Private::toggled()
{
    bool always = ui.always->isChecked();
    bool available = ui.available->isChecked();
    ui.inactive->setVisible(always | available);
    ui.line->setVisible(always | available);
    ui.unavailable->setVisible(always);
    ui.unavailable->setEnabled(ui.inactive->isEnabled() && !ui.inactive->isChecked());
}

N900Settings::N900Settings(QimsysAbstractPluginObject *plugin, QWidget *parent)
    : QimsysSettingsWidget(parent)
{
    d = new Private(plugin, this);
}

N900Settings::~N900Settings()
{
    delete d;
}

void N900Settings::save()
{
    d->save();
    QimsysSettingsWidget::save();
}

#include "n900settings.moc"
