/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "candidatewindowobject.h"
#include "candidatewindow.h"
#include "translator.h"

class CandidateWindowObject::Private : private QObject
{
    Q_OBJECT
public:
    Private(CandidateWindowObject *parent);
    ~Private();

private slots:
    void enabledChanged(bool enabled);

private:
    CandidateWindowObject *q;
public:
    CandidateWindow *window;
};

CandidateWindowObject::Private::Private(CandidateWindowObject *parent)
    : QObject(parent)
    , q(parent)
    , window(0)
{
    q->setGroups(QStringList() << QLatin1String("X11 Classic"));
    q->setCategoryType(OneOrNone);
    TR(q, "categoryName", this, QT_TR_NOOP("User Interface/Candidate Window"));

    q->setIcon(QIcon(":/candidatewindow.png"));
    TR(q, "name", this, QT_TR_NOOP("Simple candidate window"));
    TR(q, "author", this, QT_TR_NOOP("Tasuku Suzuki"));
    TR(q, "translator", this, QT_TR_NOOP("None"));
    connect(q, SIGNAL(enabledChanged(bool)), this, SLOT(enabledChanged(bool)));
    enabledChanged(q->isEnabled());
}

CandidateWindowObject::Private::~Private()
{
    delete window;
}

void CandidateWindowObject::Private::enabledChanged(bool enabled)
{
    if (enabled && !window) {
        window = new CandidateWindow;
    } else if (!enabled && window) {
        delete window;
        window = 0;
    }
}

CandidateWindowObject::CandidateWindowObject(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

CandidateWindowObject::~CandidateWindowObject()
{
    delete d;
}

#include "candidatewindowobject.moc"
