/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "aboutqimsys.h"
#include "ui_aboutqimsys.h"

#include "qimsysdebug.h"
#include "translator.h"

#include <QFile>
#include <QSettings>
#include <QTextStream>

class AboutQimsys::Private : private QObject
{
    Q_OBJECT
public:
    Private(AboutQimsys *parent);
    ~Private();

private:
    QString read(const QString &fileName);

private:
    AboutQimsys *q;
    Ui::AboutQimsys ui;
};

AboutQimsys::Private::Private(AboutQimsys *parent)
    : QObject(parent)
    , q(parent)
{
    Translator::begin();
    ui.setupUi(q);
    Translator::ui(q);
    Translator::end();

    TR(ui.aboutQimsys, "text", this
       , QT_TR_NOOP("<span style=\"font-size: 15px; font-weight: bold;\">QIMSYS version %1</span><br /><br />\n"
                    "An input method for Qt<br /><br />\n"
                    "Copyright &copy; 2009 Tasuku Suzuki &lt;<a href=\"mailto:stasuku@gmail.com\">stasuku@gmail.com</a>&gt;<br />\n"
                   ), "0.1.0");

    ui.lgpl->setPlainText(read(":/LICENSE.LGPL"));
    ui.lgplException->setPlainText(read(":/LGPL_EXCEPTION.TXT"));
    ui.tabWidget->setCornerWidget(ui.buttonBox, Qt::BottomRightCorner);

    QSettings settings;
    settings.beginGroup(q->metaObject()->className());
    q->resize(settings.value("Size", q->size()).toSize());
}

AboutQimsys::Private::~Private()
{
    QSettings settings;
    settings.beginGroup(q->metaObject()->className());
    settings.setValue("Size", q->size());
}

QString AboutQimsys::Private::read(const QString &fileName)
{
    QString ret;
    QFile file(fileName);
    if (file.open(QFile::ReadOnly | QFile::Text)) {
        ret = file.readAll();
        file.close();
    } else {
        ret = file.errorString();
    }
    return ret;
}

AboutQimsys::AboutQimsys(QObject *parent)
    : QWidget(qobject_cast<QWidget*>(parent))
{
    d = new Private(this);
}

AboutQimsys::~AboutQimsys()
{
    delete d;
}

#include "aboutqimsys.moc"
