/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "anthydic.h"
#include "anthydicmodel.h"
#include "anthywordeditor.h"

class AnthyDic::Private
{
public:
    AnthyDicModel *model;
};

AnthyDic::AnthyDic(QObject *parent)
    : QimsysEngineDictionary(parent)
{
    d = new Private;
    d->model = 0;
}

AnthyDic::~AnthyDic()
{
    delete d;
}

void AnthyDic::save()
{
    d->model->save();
}

QAbstractTableModel *AnthyDic::model()
{
    if (!d->model) {
        d->model = new AnthyDicModel(this);
    }
    return d->model;
}

void AnthyDic::add(QWidget *parent)
{
    AnthyWordEditor editor(parent);
    if (editor.exec()) {
        int row = d->model->rowCount();
        d->model->insertRow(row);
        d->model->setData(d->model->index(row, AnthyDicModel::Sound), editor.sound());
        d->model->setData(d->model->index(row, AnthyDicModel::Spelling), editor.spelling());
        d->model->setData(d->model->index(row, AnthyDicModel::WordType), editor.wordType());
        d->model->setData(d->model->index(row, AnthyDicModel::Frequency), editor.frequency());
    }
}

void AnthyDic::edit(const QModelIndex &index, QWidget *parent)
{
    AnthyWordEditor editor(parent);
    int row = index.row();
    editor.setSound(d->model->data(d->model->index(row, AnthyDicModel::Sound)).toString());
    editor.setSpelling(d->model->data(d->model->index(row, AnthyDicModel::Spelling)).toString());
    editor.setWordType(d->model->data(d->model->index(row, AnthyDicModel::WordType)).toString());
    editor.setFrequency(d->model->data(d->model->index(row, AnthyDicModel::Frequency)).toInt());
    if (editor.exec()) {
        d->model->setData(d->model->index(row, AnthyDicModel::Sound), editor.sound());
        d->model->setData(d->model->index(row, AnthyDicModel::Spelling), editor.spelling());
        d->model->setData(d->model->index(row, AnthyDicModel::WordType), editor.wordType());
        d->model->setData(d->model->index(row, AnthyDicModel::Frequency), editor.frequency());
    }
}

void AnthyDic::del(const QModelIndex &index, QWidget *parent)
{
    Q_UNUSED(parent)
    int row = index.row();
    d->model->removeRow(row, index.parent());
}
