/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef QIMSYSCANDIDATES_H
#define QIMSYSCANDIDATES_H

#include "qimsysglobal.h"
#include "qimsysabstractipcobject.h"
#include "qimsysconversionitem.h"

class QIMSYS_EXPORT QimsysCandidates : public QimsysAbstractIpcObject
{
    Q_OBJECT
    Q_PROPERTY(QimsysConversionItemList candidates READ candidates WRITE setCandidates)
    Q_PROPERTY(int currentIndex READ currentIndex WRITE setCurrentIndex)
    Q_CLASSINFO("D-Bus Interface", "local.Candidates")
    Q_DISABLE_COPY(QimsysCandidates)
public:
    explicit QimsysCandidates(QObject *parent = 0, Type type = Client);
    ~QimsysCandidates();

    bool init();

    QimsysConversionItemList candidates() const;
    int currentIndex() const;

public slots:
    void setCandidates(const QimsysConversionItemList &candidates);
    void setCurrentIndex(int currentIndex);
    void clear();

signals:
    void candidatesChanged(const QimsysConversionItemList &candidates);
    void currentIndexChanged(int currentIndex);

protected:
    QimsysAbstractIpcObject *server() const;

private:
    class Private;
    Private *d;
};

#endif // QIMSYSCANDIDATES_H
