/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef QIMSYSABSTRACTPLUGINOBJECT_H
#define QIMSYSABSTRACTPLUGINOBJECT_H

#include "qimsysglobal.h"
#include <QObject>
#include <QIcon>

class QimsysSettingsWidget;

class QIMSYS_EXPORT QimsysAbstractPluginObject : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QIcon icon READ icon WRITE setIcon NOTIFY iconChanged)
    Q_PROPERTY(QString name READ name WRITE setName NOTIFY nameChanged)
    Q_PROPERTY(QString description READ description WRITE setDescription NOTIFY descriptionChanged)
    Q_PROPERTY(QString author READ author WRITE setAuthor NOTIFY authorChanged)
    Q_PROPERTY(QString url READ url WRITE setUrl NOTIFY urlChanged)
    Q_PROPERTY(QString translator READ translator WRITE setTranslator NOTIFY translatorChanged)
    Q_PROPERTY(QString license READ license WRITE setLicense NOTIFY licenseChanged)
    Q_PROPERTY(bool enabled READ isEnabled WRITE setEnabled NOTIFY enabledChanged)
    Q_PROPERTY(QStringList groups READ groups WRITE setGroups)
    Q_PROPERTY(CategoryType categoryType READ categoryType WRITE setCategoryType)
    Q_PROPERTY(QString categoryName READ categoryName WRITE setCategoryName)
public:
    enum CategoryType {
        Hidden = 0x00,
        CanBeNone = 0x01,
        AlwaysOne = 0x02,
        MoreThanOne = 0x04,
        OneOrNone = 0x08,
        All = 0x10,
    };
    QimsysAbstractPluginObject(QObject *parent = 0);
    ~QimsysAbstractPluginObject();

    virtual const QIcon &icon() const;
    virtual const QString &name() const;
    virtual const QString &description() const;
    virtual const QString &author() const;
    virtual const QString &url() const;
    virtual const QString &translator() const;
    virtual const QString &license() const;

    bool isEnabled() const;

    virtual const QStringList &groups() const;
    virtual CategoryType categoryType() const;
    virtual const QString &categoryName() const;
    virtual QimsysSettingsWidget *settings(const QString &hint, QWidget *parent = 0);

public slots:
    void setEnabled(bool enabled);

signals:
    void iconChanged(const QIcon &icon);
    void nameChanged(const QString &name);
    void descriptionChanged(const QString &description);
    void authorChanged(const QString &author);
    void urlChanged(const QString &url);
    void translatorChanged(const QString &translator);
    void licenseChanged(const QString &license);

protected slots:
    virtual void setIcon(const QIcon &icon);
    virtual void setName(const QString &name);
    virtual void setDescription(const QString &description);
    virtual void setAuthor(const QString &author);
    virtual void setUrl(const QString &url);
    virtual void setTranslator(const QString &translator);
    virtual void setLicense(const QString &license);
    virtual void setGroups(const QStringList &groups);
    virtual void setCategoryType(CategoryType categoryType);
    virtual void setCategoryName(const QString &categoryName);

signals:
    void enabledChanged(bool enabled);

private:
    class Private;
    Private *d;
};

#endif//QIMSYSABSTRACTPLUGINOBJECT_H
