/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef QIMSYSPREEDIT_H
#define QIMSYSPREEDIT_H

#include "qimsysglobal.h"
#include "qimsysabstractipcobject.h"
#include "qimsyspreedititem.h"
#include <QRect>
#include <QFont>

class QIMSYS_EXPORT QimsysPreedit : public QimsysAbstractIpcObject
{
    Q_OBJECT
    Q_PROPERTY(QimsysPreeditItemList items READ items WRITE setItems NOTIFY itemsChanged)
    Q_PROPERTY(QRect rect READ rect WRITE setRect NOTIFY rectChanged)
    Q_PROPERTY(QFont font READ font WRITE setFont NOTIFY fontChanged)
    Q_PROPERTY(int cursorPosition READ cursorPosition WRITE setCursorPosition NOTIFY cursorPositionChanged)
    Q_PROPERTY(QString surroundingText READ surroundingText WRITE setSurroundingText NOTIFY surroundingTextChanged)
    Q_PROPERTY(QString currentSelection READ currentSelection WRITE setCurrentSelection NOTIFY currentSelectionChanged)
    Q_PROPERTY(int maximumTextLength READ maximumTextLength WRITE setMaximumTextLength NOTIFY maximumTextLengthChanged)
    Q_CLASSINFO("D-Bus Interface", "local.Preedit")
    Q_DISABLE_COPY(QimsysPreedit)
public:
    explicit QimsysPreedit(QObject *parent = 0, Type type = Client);
    ~QimsysPreedit();

    virtual bool init();

public slots:
    virtual QimsysPreeditItemList items() const;
    virtual QRect rect() const;
    virtual QFont font() const;
    virtual int cursorPosition() const;
    virtual QString surroundingText() const;
    virtual QString currentSelection() const;
    virtual int maximumTextLength() const;

public slots:
    virtual void setItems(const QimsysPreeditItemList &items);
    virtual void setRect(const QRect &rect);
    virtual void setFont(const QFont &font);
    virtual void setCursorPosition(int cursorPosition);
    virtual void setSurroundingText(const QString &surroundingText);
    virtual void setCurrentSelection(const QString &currentSelection);
    virtual void setMaximumTextLength(int maximumTextLength);

    virtual void commit(uint target = 0);

signals:
    void itemsChanged(const QimsysPreeditItemList &items);
    void rectChanged(const QRect &rect);
    void fontChanged(const QFont &font);
    void cursorPositionChanged(int cursorPosition);
    void surroundingTextChanged(const QString &surroundingText);
    void currentSelectionChanged(const QString &currentSelection);
    void maximumTextLengthChanged(int maximumTextLength);

    void committed(const QString &commitString, uint target);

protected:
    QimsysAbstractIpcObject *server() const;

private:
    class Private;
    Private *d;
};

#ifndef QIMSYS_NO_DBUS
DBUSARGUMENT_OUT(QFont value,
                 arg.beginStructure();
                 arg << value.toString();
                 arg.endStructure();
                )

DBUSARGUMENT_IN(QFont &value,
                arg.beginStructure();
                value.fromString(qdbus_cast<QString>(arg));
                arg.endStructure();
               )
#endif // QIMSYS_NO_DBUS

#endif // QIMSYSPREEDIT_H
