/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "qimsyspreedititemlist.h"
#include "qimsysdebug.h"
#include "dbus.h"

static void qimsys_preedit_item_list_finalize(GObject *gobject);

G_DEFINE_TYPE(QimsysPreeditItemList, qimsys_preedit_item_list, G_TYPE_OBJECT)

static void qimsys_preedit_item_list_class_init(QimsysPreeditItemListClass *klass)
{
    G_OBJECT_CLASS(klass)->finalize = qimsys_preedit_item_list_finalize;
}

static void qimsys_preedit_item_list_init(QimsysPreeditItemList *qpil)
{
    qimsys_debug_in();
    qpil->items = g_array_new(TRUE, TRUE, sizeof(QimsysPreeditItem));
    qimsys_debug_out();
}

QimsysPreeditItemList *qimsys_preedit_item_list_new()
{
    return QIMSYSPREEDITITEMLIST(g_object_new(QIMSYSPREEDITITEMLIST_TYPE, NULL));
}

static void qimsys_preedit_item_list_finalize(GObject *gobject)
{
    QimsysPreeditItemList *qpil = QIMSYSPREEDITITEMLIST(gobject);
    g_array_free(qpil->items, TRUE);
}
