/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "qimsyspreedit.h"
#include "qimsysdebug.h"
#include "dbus.h"
#include "qimsysmarshalers.h"

enum {
    QIMSYSPREEDIT_ITEMS_CHANGED,
    QIMSYSPREEDIT_RECT_CHANGED,
#ifdef QIMSYSPREEDIT_FONT_SUPPORT
    QIMSYSPREEDIT_FONT_CHANGED,
#endif
    QIMSYSPREEDIT_CURRENT_POSIION_CHANGED,
    QIMSYSPREEDIT_SURROUNDING_TEXT_CHANGED,
    QIMSYSPREEDIT_CURRENT_SELECTION_CHANGED,
    QIMSYSPREEDIT_MAXIMUM_TEXT_LENGTH_CHANGED,
    QIMSYSPREEDIT_COMMITTED,
    QIMSYSPREEDIT_LAST_SIGNAL
};

static guint qimsys_preedit_signals[QIMSYSPREEDIT_LAST_SIGNAL] = { 0, 0, 0 };

G_DEFINE_TYPE(QimsysPreedit, qimsys_preedit, QIMSYSABSTRACTIPCOBJECT_TYPE)

static void qimsys_preedit_items_changed(DBusGProxy *proxy, GPtrArray *values, gpointer user_data);
static void qimsys_preedit_rect_changed(DBusGProxy *proxy, GValueArray *values, gpointer user_data);
#ifdef QIMSYSPREEDIT_FONT_SUPPORT
static void qimsys_preedit_font_changed(DBusGProxy *proxy, char *value, gpointer user_data);
#endif
static void qimsys_preedit_cursor_position_changed(DBusGProxy *proxy, int cursor_position, gpointer user_data);
static void qimsys_preedit_surrounding_text_changed(DBusGProxy *proxy, char *surrounding_text, gpointer user_data);
static void qimsys_preedit_current_selection_changed(DBusGProxy *proxy, char *current_selection, gpointer user_data);
static void qimsys_preedit_maximum_text_length_changed(DBusGProxy *proxy, int maximum_text_length, gpointer user_data);
static void qimsys_preedit_committed(DBusGProxy *proxy, char *value, guint target, gpointer user_data);

#define QIMSYS_STRUCT_RECT (dbus_g_type_get_struct ("GValueArray", G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INVALID))
#ifdef QIMSYSPREEDIT_FONT_SUPPORT
#define G_STRUCT_STRING (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_INVALID))
#endif

static void qimsys_preedit_class_init(QimsysPreeditClass *klass)
{
    qimsys_preedit_signals[QIMSYSPREEDIT_ITEMS_CHANGED]
            = g_signal_new("items-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysPreeditClass, qimsys_preedit),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__OBJECT,
                           G_TYPE_NONE, 1, G_TYPE_OBJECT);
    qimsys_preedit_signals[QIMSYSPREEDIT_RECT_CHANGED]
            = g_signal_new("rect-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysPreeditClass, qimsys_preedit),
                           NULL, NULL,
                           qimsys_marshal_VOID__INT_INT_INT_INT,
                           G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
#ifdef QIMSYSPREEDIT_FONT_SUPPORT
    qimsys_preedit_signals[QIMSYSPREEDIT_FONT_CHANGED]
            = g_signal_new("font_changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysPreeditClass, qimsys_preedit),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__STRING,
                           G_TYPE_NONE, 1, G_TYPE_STRING);
#endif
    qimsys_preedit_signals[QIMSYSPREEDIT_CURRENT_POSIION_CHANGED]
            = g_signal_new("current-position-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysPreeditClass, qimsys_preedit),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__INT,
                           G_TYPE_NONE, 1, G_TYPE_INT);
    qimsys_preedit_signals[QIMSYSPREEDIT_SURROUNDING_TEXT_CHANGED]
            = g_signal_new("surrounding-text-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysPreeditClass, qimsys_preedit),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__CHAR,
                           G_TYPE_NONE, 1, G_TYPE_CHAR);
    qimsys_preedit_signals[QIMSYSPREEDIT_CURRENT_SELECTION_CHANGED]
            = g_signal_new("current-selection-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysPreeditClass, qimsys_preedit),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__CHAR,
                           G_TYPE_NONE, 1, G_TYPE_CHAR);
    qimsys_preedit_signals[QIMSYSPREEDIT_MAXIMUM_TEXT_LENGTH_CHANGED]
            = g_signal_new("maximum-text-length-changed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysPreeditClass, qimsys_preedit),
                           NULL, NULL,
                           g_cclosure_marshal_VOID__INT,
                           G_TYPE_NONE, 1, G_TYPE_INT);
    qimsys_preedit_signals[QIMSYSPREEDIT_COMMITTED]
            = g_signal_new("committed",
                           G_TYPE_FROM_CLASS(klass),
                           G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
                           G_STRUCT_OFFSET(QimsysPreeditClass, qimsys_preedit),
                           NULL, NULL,
                           qimsys_marshal_VOID__STRING_UINT,
                           G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_UINT);
}

static void qimsys_preedit_init(QimsysPreedit *qam)
{
    QimsysAbstractIpcObject *qaio;
    qimsys_debug_in();

    qaio = QIMSYSABSTRACTIPCOBJECT(qam);

    /* Create a proxy object */
    qimsys_abstract_ipc_object_connect(qaio, QIMSYS_DBUS_SERVICE, "/QimsysPreedit", "local.Preedit");

    dbus_g_proxy_add_signal(qaio->proxy, "itemsChanged", QIMSYS_STRUCT_PREEDITITEMLIST, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "itemsChanged", G_CALLBACK(qimsys_preedit_items_changed), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "rectChanged", QIMSYS_STRUCT_RECT, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "rectChanged", G_CALLBACK(qimsys_preedit_rect_changed), qam, NULL);

#ifdef QIMSYSPREEDIT_FONT_SUPPORT
    dbus_g_proxy_add_signal(qaio->proxy, "fontChanged", G_TYPE_STRING, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "fontChanged", G_CALLBACK(qimsys_preedit_font_changed), qam, NULL);
#endif

    dbus_g_proxy_add_signal(qaio->proxy, "currentPositionChanged", G_TYPE_INT, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "currentPositionChanged", G_CALLBACK(qimsys_preedit_cursor_position_changed), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "surroundingTextChanged", G_TYPE_STRING, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "surroundingTextChanged", G_CALLBACK(qimsys_preedit_surrounding_text_changed), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "currentSelectionChanged", G_TYPE_STRING, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "currentSelectionChanged", G_CALLBACK(qimsys_preedit_current_selection_changed), qam, NULL);

    dbus_g_proxy_add_signal(qaio->proxy, "maximumTextLengthChanged", G_TYPE_INT, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "maximumTextLengthChanged", G_CALLBACK(qimsys_preedit_maximum_text_length_changed), qam, NULL);

    dbus_g_object_register_marshaller(qimsys_marshal_VOID__STRING_UINT, G_TYPE_NONE, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID);
    dbus_g_proxy_add_signal(qaio->proxy, "committed", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID);
    dbus_g_proxy_connect_signal(qaio->proxy, "committed", G_CALLBACK(qimsys_preedit_committed), qam, NULL);

    qimsys_debug_out();
}

QimsysPreedit *qimsys_preedit_new()
{
    return QIMSYSPREEDIT(g_object_new(QIMSYSPREEDIT_TYPE, NULL));
}

gboolean qimsys_preedit_get_items(QimsysPreedit *qam, QimsysPreeditItemList **values)
{
    guint i;
    gboolean ret = TRUE;
    GError *error = NULL;
    QimsysPreeditItem item;
    GPtrArray *items2;
    GValueArray* item2;
    GValue *value;
    qimsys_debug_in();

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "items", &error, G_TYPE_INVALID, QIMSYS_STRUCT_PREEDITITEMLIST, &items2, G_TYPE_INVALID))

    *values = qimsys_preedit_item_list_new();
    for (i = 0; i < items2->len; i++) {
        item2 = g_ptr_array_index(items2, i);
        value = g_value_array_get_nth(item2, 0);
        item.text = g_value_get_string(value);
        value = g_value_array_get_nth(item2, 1);
        item.cursor = g_value_get_int(value);
        value = g_value_array_get_nth(item2, 2);
        item.selection = g_value_get_int(value);
        value = g_value_array_get_nth(item2, 3);
        item.underline_style = g_value_get_int(value);
        g_array_append_val((*values)->items, item);
    }
//    g_ptr_array_free(items2, TRUE);

    qimsys_debug_out();
    return ret;
}

gboolean qimsys_preedit_set_items(QimsysPreedit *qam, QimsysPreeditItemList *values)
{
    guint i;
    gboolean ret = TRUE;
    GError *error = NULL;
    QimsysPreeditItem item;
    GPtrArray *items2;
    GValueArray *item2;
    GValue value = {0, };
    qimsys_debug_in();

    items2 = g_ptr_array_new();
    for (i = 0; i < values->items->len; i++) {
        item = g_array_index(values->items, QimsysPreeditItem, i);
        item2 = g_value_array_new(0);

        g_value_init(&value, G_TYPE_STRING);
        g_value_set_string(&value, item.text);
        g_value_array_append(item2, &value);
        g_value_unset(&value);

        g_value_init(&value, G_TYPE_INT);
        g_value_set_int(&value, item.cursor);
        g_value_array_append(item2, &value);

        g_value_set_int(&value, item.selection);
        g_value_array_append(item2, &value);

        g_value_set_int(&value, item.selection);
        g_value_array_append(item2, &value);
        g_value_unset(&value);

        g_ptr_array_add(items2, item2);
    }
    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setItems", &error, QIMSYS_STRUCT_PREEDITITEMLIST, items2, G_TYPE_INVALID, G_TYPE_INVALID))

    g_ptr_array_free(items2, TRUE);
    qimsys_debug_out();
    return ret;
}

static void qimsys_preedit_items_changed(DBusGProxy *proxy, GPtrArray *values, gpointer user_data)
{
    guint i;
    QimsysPreeditItemList *items;
    QimsysPreeditItem item;
    GValueArray *item2;
    GValue *value;
    qimsys_debug_in();

    items = qimsys_preedit_item_list_new();
    for (i = 0; i < values->len; i++) {
        item2 = g_ptr_array_index(values, i);
        value = g_value_array_get_nth(item2, 0);
        item.text = g_strdup(g_value_get_string(value));
        value = g_value_array_get_nth(item2, 1);
        item.cursor = g_value_get_int(value);
        value = g_value_array_get_nth(item2, 2);
        item.selection = g_value_get_int(value);
        value = g_value_array_get_nth(item2, 3);
        item.underline_style = g_value_get_int(value);
        g_array_append_val(items->items, item);
    }
    g_signal_emit(QIMSYSPREEDIT(user_data), qimsys_preedit_signals[QIMSYSPREEDIT_ITEMS_CHANGED], 0, items);
//    g_ptr_array_free(values, TRUE);
    qimsys_debug_out();
}

gboolean qimsys_preedit_get_rect(QimsysPreedit *qam, int *x, int *y, int *w, int *h)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValueArray *values;
    GValue *value;
    qimsys_debug_in();

    values = g_value_array_new(4);

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "rect", &error, G_TYPE_INVALID, QIMSYS_STRUCT_RECT, &values, G_TYPE_INVALID))

    value = g_value_array_get_nth(values, 0);
    *x = g_value_get_int(value);
    g_value_unset(value);
    value = g_value_array_get_nth(values, 1);
    *y = g_value_get_int(value);
    g_value_unset(value);
    value = g_value_array_get_nth(values, 2);
    *w = g_value_get_int(value);
    g_value_unset(value);
    value = g_value_array_get_nth(values, 3);
    *h = g_value_get_int(value);
    g_value_unset(value);

    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

gboolean qimsys_preedit_set_rect(QimsysPreedit *qam, int x, int y, int w, int h)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValue value = {0, };
    GValueArray *values;

    qimsys_debug_in();
    values = g_value_array_new(0);

    g_value_init(&value, G_TYPE_INT);
    g_value_set_int(&value, x);
    g_value_array_append(values, &value);
    g_value_unset(&value);

    g_value_init(&value, G_TYPE_INT);
    g_value_set_int(&value, y);
    g_value_array_append(values, &value);
    g_value_unset(&value);

    g_value_init(&value, G_TYPE_INT);
    g_value_set_int(&value, w);
    g_value_array_append(values, &value);
    g_value_unset(&value);

    g_value_init(&value, G_TYPE_INT);
    g_value_set_int(&value, h);
    g_value_array_append(values, &value);
    g_value_unset(&value);

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setRect", &error, QIMSYS_STRUCT_RECT, values, G_TYPE_INVALID, G_TYPE_INVALID))

    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

static void qimsys_preedit_rect_changed(DBusGProxy *proxy, GValueArray *values, gpointer user_data)
{
    gint x, y, w, h;
    GValue *value;
    qimsys_debug_in();
    value = g_value_array_get_nth(values, 0);
    x = g_value_get_int(value);
    g_value_unset(value);
    value = g_value_array_get_nth(values, 1);
    y = g_value_get_int(value);
    g_value_unset(value);
    value = g_value_array_get_nth(values, 2);
    w = g_value_get_int(value);
    g_value_unset(value);
    value = g_value_array_get_nth(values, 3);
    h = g_value_get_int(value);
    g_value_unset(value);
    g_signal_emit(QIMSYSPREEDIT(user_data), qimsys_preedit_signals[QIMSYSPREEDIT_RECT_CHANGED], 0, x, y, w, h);
    qimsys_debug_out();
}

#ifdef QIMSYSPREEDIT_FONT_SUPPORT
gboolean qimsys_preedit_get_font(QimsysPreedit *qam, char **value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValueArray *values;
    GValue *v;

    qimsys_debug_in();
    values = g_value_array_new(4);

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "font", &error, G_TYPE_INVALID, G_STRUCT_STRING, values, G_TYPE_INVALID))

    v = g_value_array_get_nth(values, 0);
    *value = g_value_get_string(v);
    g_value_unset(v);
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

gboolean qimsys_preedit_set_font(QimsysPreedit *qam, char *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValue v = {0};
    GValueArray *values;
    qimsys_debug_in();

    values = g_value_array_new(0);

    g_value_init(&v, G_TYPE_STRING);
    g_value_set_string(&v, value);
    g_value_array_append(values, &v);
    g_value_unset(&v);

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setFont", &error, G_STRUCT_STRING, values, G_TYPE_INVALID, G_TYPE_INVALID))
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

static void qimsys_preedit_font_changed(DBusGProxy *proxy, char *value, gpointer user_data)
{
//    g_signal_emit(QIMSYSPREEDIT(user_data), qimsys_preedit_signals[QIMSYSPREEDIT_FONT_CHANGED], 0, value);
}
#endif

gboolean qimsys_preedit_get_cursor_position(QimsysPreedit *qam, int *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValueArray *values;
    GValue *v;

    qimsys_debug_in();
    values = g_value_array_new(4);

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "currentPosition", &error, G_TYPE_INVALID, G_TYPE_INT, values, G_TYPE_INVALID))

    v = g_value_array_get_nth(values, 0);
    *value = g_value_get_int(v);
    g_value_unset(v);
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

gboolean qimsys_preedit_set_cursor_position(QimsysPreedit *qam, int value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValue v = {0};
    GValueArray *values;
    qimsys_debug_in();

    values = g_value_array_new(0);

    g_value_init(&v, G_TYPE_INT);
    g_value_set_int(&v, value);
    g_value_array_append(values, &v);
    g_value_unset(&v);

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setCurrentPosition", &error, G_TYPE_INT, values, G_TYPE_INVALID, G_TYPE_INVALID))
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

static void qimsys_preedit_cursor_position_changed(DBusGProxy *proxy, int value, gpointer user_data)
{
    g_signal_emit(QIMSYSPREEDIT(user_data), qimsys_preedit_signals[QIMSYSPREEDIT_CURRENT_POSIION_CHANGED], 0, value);
}

gboolean qimsys_preedit_get_surrounding_text(QimsysPreedit *qam, char **value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValueArray *values;
    GValue *v;

    qimsys_debug_in();
    values = g_value_array_new(4);

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "surroundingText", &error, G_TYPE_INVALID, G_TYPE_STRING, values, G_TYPE_INVALID))

    v = g_value_array_get_nth(values, 0);
    *value = g_value_get_string(v);
    g_value_unset(v);
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

gboolean qimsys_preedit_set_surrounding_text(QimsysPreedit *qam, const char *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValue v = {0};
    GValueArray *values;
    qimsys_debug_in();

    values = g_value_array_new(0);

    g_value_init(&v, G_TYPE_STRING);
    g_value_set_string(&v, value);
    g_value_array_append(values, &v);
    g_value_unset(&v);

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setSurroundingText", &error, G_TYPE_STRING, values, G_TYPE_INVALID, G_TYPE_INVALID))
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

static void qimsys_preedit_surrounding_text_changed(DBusGProxy *proxy, char *value, gpointer user_data)
{
    g_signal_emit(QIMSYSPREEDIT(user_data), qimsys_preedit_signals[QIMSYSPREEDIT_SURROUNDING_TEXT_CHANGED], 0, value);
}

gboolean qimsys_preedit_get_current_selection(QimsysPreedit *qam, char **value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValueArray *values;
    GValue *v;

    qimsys_debug_in();
    values = g_value_array_new(4);

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "currentSelection", &error, G_TYPE_INVALID, G_TYPE_STRING, values, G_TYPE_INVALID))

    v = g_value_array_get_nth(values, 0);
    *value = g_value_get_string(v);
    g_value_unset(v);
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

gboolean qimsys_preedit_set_current_selection(QimsysPreedit *qam, const char *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValue v = {0};
    GValueArray *values;
    qimsys_debug_in();

    values = g_value_array_new(0);

    g_value_init(&v, G_TYPE_STRING);
    g_value_set_string(&v, value);
    g_value_array_append(values, &v);
    g_value_unset(&v);

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setCurrentSelection", &error, G_TYPE_STRING, values, G_TYPE_INVALID, G_TYPE_INVALID))
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

static void qimsys_preedit_current_selection_changed(DBusGProxy *proxy, char *value, gpointer user_data)
{
    g_signal_emit(QIMSYSPREEDIT(user_data), qimsys_preedit_signals[QIMSYSPREEDIT_CURRENT_SELECTION_CHANGED], 0, value);
}

gboolean qimsys_preedit_get_maximum_text_length(QimsysPreedit *qam, int *value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValueArray *values;
    GValue *v;

    qimsys_debug_in();
    values = g_value_array_new(4);

    CHECK_DBUS_ERROR(ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "maximumTextLength", &error, G_TYPE_INVALID, G_TYPE_INT, values, G_TYPE_INVALID))

    v = g_value_array_get_nth(values, 0);
    *value = g_value_get_int(v);
    g_value_unset(v);
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

gboolean qimsys_preedit_set_maximum_text_length(QimsysPreedit *qam, int value)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    GValue v = {0};
    GValueArray *values;
    qimsys_debug_in();

    values = g_value_array_new(0);

    g_value_init(&v, G_TYPE_INT);
    g_value_set_string(&v, value);
    g_value_array_append(values, &v);
    g_value_unset(&v);

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "setMaximumTextLength", &error, G_TYPE_INT, values, G_TYPE_INVALID, G_TYPE_INVALID))
    g_value_array_free(values);
    qimsys_debug_out();
    return ret;
}

static void qimsys_preedit_maximum_text_length_changed(DBusGProxy *proxy, int value, gpointer user_data)
{
    g_signal_emit(QIMSYSPREEDIT(user_data), qimsys_preedit_signals[QIMSYSPREEDIT_MAXIMUM_TEXT_LENGTH_CHANGED], 0, value);
}

gboolean qimsys_preedit_commit(QimsysPreedit *qam, guint target)
{
    gboolean ret = TRUE;
    GError *error = NULL;
    qimsys_debug_in();

    CHECK_DBUS_ERROR (ret, !dbus_g_proxy_call(QIMSYSABSTRACTIPCOBJECT(qam)->proxy, "commit", &error, G_TYPE_UINT, target, G_TYPE_INVALID, G_TYPE_INVALID))

    qimsys_debug_out();
    return ret;
}

static void qimsys_preedit_committed(DBusGProxy *proxy, char *value, guint target, gpointer user_data)
{
//    qimsys_debug_in();
    g_signal_emit(QIMSYSPREEDIT(user_data), qimsys_preedit_signals[QIMSYSPREEDIT_COMMITTED], 0, value, target);
//    qimsys_debug_out();
}
