TEMPLATE = lib

unix:QJSON_INSTALL_DIR = "/usr"
#unix:INSTALL_PREFIX = "/usr

include(../qfacebook.pri)

QT -= gui
QT += network

TARGET = qfacebook
DESTDIR  = ../lib
CONFIG += create_prl

DEFINES += QFACEBOOK_LIBRARY

!isEmpty(QJSON_INSTALL_DIR) {
    INCLUDEPATH += $$quote($$QJSON_INSTALL_DIR/include)
    LIBS += -L$$quote($$QJSON_INSTALL_DIR/lib)
}

LIBS += -lqjson

SOURCES += \
    qfacebook.cpp \
    graphapi.cpp \
    qfacebookreply.cpp

HEADERS += \
    qfacebook.h \
    qfacebook_global.h \
    graphapi.h \
    qfacebookreply.h


headers.files = qfacebook.h qfacebookreply.h

!isEmpty(INSTALL_PREFIX) {
    target.path = $$INSTALL_PREFIX/lib
    headers.path = $$INSTALL_PREFIX/include/qfacebook

    INSTALLS += target headers
}

symbian: {

  #export public header to \epocroot\epoc32\include to be able to use them
  headers.path = $$PWD/qfacebook
  for(header, headers.files) {
    {BLD_INF_RULES.prj_exports += "$$header"}
  }

  TARGET.EPOCALLOWDLLDATA = 1
  # uid for the dll
  #TARGET.UID3=
  TARGET.CAPABILITY = ReadDeviceData WriteDeviceData

  # add dll to the sis
  QFacebookDeployment.sources = $${TARGET}.dll
  QFacebookDeployment.path = /sys/bin

  DEPLOYMENT += QFacebookDeployment
}
