#include "weightdialog.h"
#include <QDebug>

WeightDialog::WeightDialog(QWidget *parent) :
        QDialog(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);

    //setWindowFlags(this->windowFlags() | Qt::Window);
    setWindowTitle("Save weight");

    QHBoxLayout *hLayout = new QHBoxLayout();
    QVBoxLayout *buttonLayout = new QVBoxLayout();

    modelReps = new QStandardItemModel(this);
    for (int i = 1; i <= 25; i++)
        modelReps->appendRow(new QStandardItem(tr("%1").arg(i)));

    btnReps = new QMaemo5ValueButton("Reps");
    btnReps->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorReps = new QMaemo5ListPickSelector;
    selectorReps->setModel(modelReps);
    btnReps->setPickSelector(selectorReps);


    btnVar = new QMaemo5ValueButton();
    btnVar->setValueLayout(QMaemo5ValueButton::ValueUnderText);
    selectorVar = new QMaemo5ListPickSelector;
    selectorVar->setModel(modelVar);
    btnVar->setPickSelector(selectorVar);

    buttonLayout->addWidget(btnReps);
    buttonLayout->addWidget(btnVar);
    hLayout->addLayout(buttonLayout);



    radioEasy = new QRadioButton("Easy");
    radioOK = new QRadioButton("Perfect");
    radioHard = new QRadioButton("Hard");

    QVBoxLayout *vLayout = new QVBoxLayout();
    vLayout->addWidget(radioEasy);
    vLayout->addWidget(radioOK);
    vLayout->addWidget(radioHard);
    hLayout->addLayout(vLayout);

    btnSave = new QPushButton("Save");

    hLayout->addWidget(btnSave);

    setLayout(hLayout);
    xml = new XML();
    //load();
    connect(btnSave, SIGNAL(clicked()),this,SLOT(save()));
}

void WeightDialog::load(QString name, QString grp, QString currentSet)
{
    btnVar->setText("Weight");
    QList <QString> list;

    exName = name;
    group = grp;
    set = currentSet;

    for (int i = 1; i < 200; i++)
        modelVar->appendRow(new QStandardItem(tr("%1").arg(i)+ "kg"));

    list = xml->openEx(name);





    setWindowTitle("Save weight (set:" + currentSet + ")");


}

void WeightDialog::loadCardio(QString name, QString m, QString s)
{
    btnReps->setEnabled(false);
    btnVar->setText("Distance");
    QList <QString> list;
    int select;

    group = "Cardio";
    exName = name;
    min = m;
    sec = s;
    set = 1;

    for (double i = 1; i < 500; i++)
        modelVar->appendRow(new QStandardItem(tr("%1").arg(i/10) + "km"));

    setWindowTitle("Save distance");


}

void WeightDialog::save()
{
    QString status, weight;
    if(radioOK->isChecked())
        status = "perfect";
    else if(radioEasy->isChecked())
        status = "easy";
    else if(radioHard->isChecked())
        status = "hard";
    else
        return;

    if(btnReps->valueText() == "")
        return;
    else if(btnVar->valueText() == "")
        return;

    weight = btnVar->valueText();

    if(group == "Cardio")
    {
        reps = min + ":" + sec;
        xml->updateLastDistance(exName, weight, min, sec, status);
    }
    else
    {
        reps = btnReps->valueText();
    }

    if(set.toInt() == 1)
        xml->saveFirstSet(group, exName, weight, reps, status);
    else
        xml->updateHistory(exName,set,weight,reps,status);

    emit next();
    this->hide();
}
