#include "historywindow.h"



HistoryWindow::HistoryWindow(QWidget *parent) :
    QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5PortraitOrientation);
    setWindowTitle("History");

    dh = new DayHistory(this);

    lstDates = new QListView();
    model = new QStandardItemModel(this);
    lstDates->setModel(model);

    connect(lstDates,SIGNAL(clicked(QModelIndex)),this,SLOT(showExercises(QModelIndex)));

    setCentralWidget(lstDates);
}

void HistoryWindow::changeEvent(QEvent *event)
{
    if(event->type() == QEvent::ActivationChange)
    {
        load();
    }
}

void HistoryWindow::showExercises(QModelIndex index)
{
    dh->load(index.data().toString());
    dh->show();
}

void HistoryWindow::load()
{
    model->clear();
    dates = xml->getDates();
    while(!dates.isEmpty())
    {
        model->appendRow(new QStandardItem(dates.takeFirst()));
    }
}
