#ifndef EXERCISEWINDOW_H
#define EXERCISEWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include <QDBusInterface>
#include "newexercisewindow.h"
#include "newprogramwindow.h"
#include "settingswindow.h"
#include "xml.h"
#include "athread.h"
#include "playsound.h"
#include "weightdialog.h"
#include "newingredientwindow.h"
#include "historywindow.h"
#include "exercisedialog.h"

class ExerciseWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit ExerciseWindow(QWidget *parent = 0);
    void loadExercise(QList<QString> name);

signals:
    void closed();
    void landscape();

public slots:
    void sendClosed();
    void setCurrentExercise(QString name);
    void sendDestroyDialog();

    void reopenWD();

private:
    ExerciseDialog *ed;
    SettingsWindow *sw;
    NewExerciseWindow *nw;
    NewIngredientWindow *niw;
    NewProgramWindow *npw;
    XML *xml;
    HistoryWindow *hw;
    aThread *myThread;
    PlaySound *sound;
    WeightDialog *wd;

    void createActions();
    void createMenu();
    void vibrate();
    void closeEvent(QCloseEvent *event);
    void changeEvent(QEvent *event);
    void openED();

    QFont font;

    QDBusInterface *interface;
    QDBusMessage pause;
    QDBusMessage resume;
    QDBusMessage lock;

    QAction *settingsAction;
    QAction *newExerciseAction;
    QAction *newProgramAction;
    QAction *newIngredientAction;
    QAction *skipAction;
    QAction *historyAction;

    QLabel *label;

    QPushButton *btnShake;

    QWidget *widget;

    bool vibrateActive;
    bool soundActive;
    bool proximity;

    int min, sec, set;
    int MIN, SEC, SET;
    int mx, my, mz;
    int wdCount;

    QString currentExercise, currentGroup;
    QString strMin, strSec, strSet;
    QString currentReps;
    int currentSet;
    QString weight[9], reps[9], status[9];

    QTimer *timer;
    QTimer *tmr;
    QTimer *tmrPause;

    QList <QString> exercises;

    QVBoxLayout *vLayout;

private slots:
    void resumeMusic();
    void showSettings();
    void showNewExercise();
    void showNewProgram();
    void updateTime();
    void checkAcc(QString x);
    void checkProximity(QString data);
    void shaked();
    void stopVibrate();
    void skipWait();
    void showNewIngredient();
    void showHistory();

};

#endif // EXERCISEWINDOW_H
