#include "dayhistory.h"

DayHistory::DayHistory(QWidget *parent) :
        QMainWindow(parent)
{
    setAttribute(Qt::WA_Maemo5StackedWindow);

    xml = new XML();

    lstExercises = new QListView();
    model = new QStandardItemModel(this);
    lstExercises->setModel(model);
    setCentralWidget (lstExercises);
}


void DayHistory::load(QString date)
{
    QList <QString> tmp;
    QString name, group;
    setWindowTitle(date);
    model->clear();
    exercises = xml->getHistoryByDate(date);

    while(!exercises.isEmpty())
    {
        tmp = exercises.takeFirst();
        name = tmp.takeFirst();
        group = tmp.takeFirst();

        if(group != "Cardio")
            model->appendRow(new QStandardItem(group + "/" + name ));
        else
            model->appendRow(new QStandardItem(group + "/" + name ));
    }

}
