#ifndef STARTWINDOW_H
#define STARTWINDOW_H

#include <QMainWindow>
#include "weightwindow.h"
#include <QtGui>
#include "historywindow.h"
#include "newexercisewindow.h"
#include "newprogramwindow.h"
#include "settingswindow.h"
#include "listwindow.h"
#include "xml.h"
#include <QFile>
#include "calendar.h"
#include "foodwindow.h"
#include "newingredientwindow.h"


namespace Ui {
    class StartWindow;
}

class StartWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit StartWindow(QWidget *parent = 0);
    ~StartWindow();


private:
    FoodWindow *fw;
    WeightWindow *ww;
    HistoryWindow *hw;
    SettingsWindow *sw;
    NewExerciseWindow *nw;
    NewProgramWindow *npw;
    NewIngredientWindow *niw;
    ListWindow *lw;
    XML *xml;

    void createActions();
    void createMenu();
    QList <QString> getStats();
    void checkIfFirstTime();
    //void focusInEvent(QFocusEvent  * event);
    void changeEvent(QEvent *event);
    int weeksExercise();


    QAction *settingsAction;
    QAction *newExerciseAction;
    QAction *newProgramAction;
    QAction *newIngredientAction;
    QAction *historyAction;

    QPushButton *btnWeight;
    QPushButton *btnCardio;
    QPushButton *btnProgram;
    QPushButton *btnFood;

    QLabel *lblWeight;
    QLabel *lblCardio;

    QFile *file;
private slots:
    void showFood();
    void showWeight();
    void showCardio();
    void showProgram();
    void showHistory();
    void showSettings();
    void showNewExercise();
    void showNewProgram();
    void showNewIngredient();

public slots:
    void restorePortrait();
    void setLandscape();
};

#endif // STARTWINDOW_H
