#ifndef EXERCISEWINDOW_H
#define EXERCISEWINDOW_H

#include <QMainWindow>
#include <QtGui>
#include <QDBusInterface>
#include "newexercisewindow.h"
#include "newprogramwindow.h"
#include "settingswindow.h"
#include "xml.h"
#include "athread.h"
#include "playsound.h"
#include "weightdialog.h"
#include "newingredientwindow.h"
#include "historywindow.h"

class ExerciseWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit ExerciseWindow(QWidget *parent = 0);
    void loadExercise(QList<QString> name);

private:
    SettingsWindow *sw;
    NewExerciseWindow *nw;
    NewIngredientWindow *niw;
    NewProgramWindow *npw;
    XML *xml;
    HistoryWindow *hw;
    aThread *myThread;
    PlaySound *sound;
    WeightDialog *wd;

    void createActions();
    void createMenu();
    void vibrate();
    void closeEvent(QCloseEvent *event);

    QDBusInterface *interface;
    QDBusMessage pause;
    QDBusMessage resume;
    QDBusMessage lock;

    QAction *settingsAction;
    QAction *newExerciseAction;
    QAction *newProgramAction;
    QAction *newIngredientAction;
    QAction *skipAction;
    QAction *historyAction;

    QLabel *label;

    QPushButton *btnShake;

    QWidget *widget;

    bool vibrateActive;
    bool soundActive;
    bool running;

    int min, sec, set, reps;
    int MIN, SEC, SET, REPS;
    int mx, my, mz;

    QString currentExercise,currentGroup;
    QString strReps, strMin,strSec,strSet;
    QString currentReps;

    QTimer *timer;
    QTimer *tmr;
    QTimer *tmrPause;

    QList <QString> exercises;

    QVBoxLayout *vLayout;

private slots:
    void resumeMusic();
    void showSettings();
    void showNewExercise();
    void showNewProgram();
    void update();
    void checkAcc(QString x);
    void shaked();
    void stopVibrate();
    void skipWait();
    void showNewIngredient();
    void showHistory();

};

#endif // EXERCISEWINDOW_H
