#ifndef UTILS_H
#define UTILS_H

#include "enums.h"

#ifndef QML_USER_INTERFACE
class QPainter;
class QRect;
class QImage;
#endif

class Utils : public QObject
{
    Q_OBJECT

public:
    static QString durationFromSecs(int secs);
    static QString durationFromMSecs(int msecs);
    static QString fileSizeFromPath(const QString &filePath);
    static QString fileSizeFromBytes(double bytes);
    static QString dateFromSecs(qint64 secs, bool showTime = true);
    static QString dateFromMSecs(qint64 msecs, bool showTime = true);
    static QString localDateTimeFromString(const QString &dateTimeString, Qt::DateFormat = Qt::ISODate);
    static qint64 currentMSecsSinceEpoch();
    static qint64 dateTimeToMSecsSinceEpoch(const QDateTime &dateTime);
    static QDateTime dateTimeFromMSecsSinceEpoch(qint64 msecs);
    static QString base64Id(const QString &artist, const QString &title);
    static QString httpErrorString(int errorCode);
    static void log(const QString &filePath, const QByteArray &message);
#ifndef QML_USER_INTERFACE
    static void drawBorderImage(QPainter *painter, const QRect &rect, const QImage &image, int top, int right, int left, int bottom);
#endif
};

#endif // UTILS_H
