#ifndef FILE_H
#define FILE_H

#include <QList>
#include <QMutex>
#include <QThread>
#include <QWaitCondition>
#include <QFile>

class QByteArray;

struct MetaInfo {
    qint64 size;
    qint64 bytesRemaining;
    QString name;
    QString path;
};

class File : public QThread
{
    Q_OBJECT

public:
    File(QObject *parent = 0);
    virtual ~File();

    void setMetaInfo(const MetaInfo &info);

    void write(qint64 offset, const QByteArray &data);
    QString fileName() const;
    bool remove();
    qint64 size() const;

    QString errorString() const;

protected:
    void run();

private:
    bool generateFiles();
    bool writeBlock(qint64 offset, const QByteArray &data);

private slots:
    void wakeUp();

signals:
    void error();
    void writeCompleted();

private:
    struct WriteRequest {
        qint64 offset;
        QByteArray data;
    };

    QFile m_file;
    MetaInfo m_metaInfo;
    QString m_errString;

    bool m_newFile;
    bool m_writeOnly;
    bool m_quit;
    bool m_wokeUp;

    qint64 m_bytesRemaining;
    QList<WriteRequest> m_writeRequests;

    mutable QMutex m_mutex;
    mutable QWaitCondition m_cond;
};

#endif
