#ifndef ARCHIVEPASSWORDSMODEL_H
#define ARCHIVEPASSWORDSMODEL_H

#include <QStringListModel>

class ArchivePasswordsModel : public QStringListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit ArchivePasswordsModel(QObject *parent = 0);
    ~ArchivePasswordsModel();
    
public slots:
    void addPassword(const QString &password);
    void removePassword(const QString &password);
    void removePassword(int row);

signals:
    void countChanged(int count);
};

#endif // ARCHIVEPASSWORDSMODEL_H
