#ifndef PLUGINSETTINGSSELECTOR_H
#define PLUGINSETTINGSSELECTOR_H

#include "valueselector.h"
#include <QVariant>

class PluginSettingsSelector : public ValueSelector
{
    Q_OBJECT

public:
    explicit PluginSettingsSelector(const QString &text, QWidget *parent = 0);
    ~PluginSettingsSelector();

    inline QString key() const { return m_key; }
    inline QVariant defaultValue() const { return m_default; }

public slots:
    void setKey(const QString &key);
    void setDefaultValue(const QVariant &value);
    void load();

private slots:
    void onSelected();

private:
    QString m_key;
    QVariant m_default;
};

#endif // PLUGINSETTINGSSELECTOR_H
