#ifndef PLUGINSETTINGSCOMBOBOX_H
#define PLUGINSETTINGSCOMBOBOX_H

#include <QComboBox>

class PluginSettingsCombobox : public QComboBox
{
    Q_OBJECT

public:
    explicit PluginSettingsCombobox(QWidget *parent = 0);
    ~PluginSettingsCombobox();

    inline QString key() const { return m_key; }
    inline QVariant defaultValue() const { return m_default; }

public slots:
    void setKey(const QString &key);
    void setDefaultValue(const QVariant &value);
    void load();

private slots:
    void onCurrentIndexChanged(int index);

private:
    QString m_key;
    QVariant m_default;
};

#endif // PLUGINSETTINGSCOMBOBOX_H
