#include "mainwindow.h"
#include "../shared/transfer.h"
#include "../shared/session.h"
#include "../shared/definitions.h"
#include "../dbus/dbusservice.h"
#include "../dbus/dbusserviceadaptor.h"
#include <QApplication>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setApplicationName("QDL");
    app.setApplicationVersion(VERSION_NUMBER);

    qRegisterMetaType< QList<Transfer*> >("QList<Transfer*>");
    qRegisterMetaType< QList<QUrl> >("QList<QUrl>");

    Session session;

    DBusServiceAdaptor adaptor(DBusService::instance());

    QDBusConnection connection = QDBusConnection::sessionBus();
    connection.registerService("com.marxoft.QDL");
    connection.registerObject("/", DBusService::instance());

    MainWindow window;
    window.show();

    return app.exec();
}
