#ifndef PACKAGEPROPERTIESDIALOG_H
#define PACKAGEPROPERTIESDIALOG_H

#include "../shared/transfer.h"
#include <QDialog>

class PackageTransferModel;
class QListView;
class QComboBox;

class PackagePropertiesDialog : public QDialog
{
    Q_OBJECT

public:
    explicit PackagePropertiesDialog(Transfer *package, QWidget *parent = 0);
    ~PackagePropertiesDialog();

private slots:
    void onTransferCountChanged(int count);
    void onPackageDataChanged(int role);
    void setPackageCategory(const QString &text);
    void setPackagePriority(int index);
    
private:
    Transfer *m_package;
    PackageTransferModel *m_model;
    QListView *m_view;
    QComboBox *m_categorySelector;
    QComboBox *m_prioritySelector;
    QPushButton *m_startButton;
    QPushButton *m_pauseButton;
    QPushButton *m_removeButton;
};

#endif // PACKAGEPROPERTIESDIALOG_H
