#ifndef URLRETRIEVER_H
#define URLRETRIEVER_H

#include <QObject>
#include <QQueue>
#include <QUrl>

class QNetworkReply;

class UrlRetriever : public QObject
{
    Q_OBJECT

    Q_PROPERTY(int progress
               READ progress
               NOTIFY progressChanged)

public:
    ~UrlRetriever();

    int progress() const;
    QList<QUrl> results() const { return m_results; }

    void addUrlToQueue(const QUrl &url);
    void addUrlToQueue(const QString &url);
    void addUrlsToQueue(QList<QUrl> urls);
    void addUrlsToQueue(QStringList urls);
    void parseUrlsFromText(const QString &text);
    void importUrlsFromTextFile(const QString &filePath);

    static UrlRetriever* instance();

public slots:
    void cancel();
    void clearResults();

private:
    UrlRetriever();

    void getWebPage(const QUrl &url);

private slots:
    void checkWebPage();

signals:
    void busy(const QString &message, int numberOfOperations);
    void finished();
    void progressChanged(int progress);
    void cancelled();
    
private:
    static UrlRetriever *m_instance;

    QNetworkReply *m_reply;
    QQueue<QUrl> m_urlQueue;
    QList<QUrl> m_results;
    bool m_index;
    bool m_total;
    bool m_cancelled;
};

#endif // URLRETRIEVER_H
