#ifndef DATABASE_H
#define DATABASE_H

#include <QObject>
#include <QSqlDatabase>
#include <QPair>
#include <QVariantMap>
#include <QStringList>

class Transfer;

class Database : public QObject
{
    Q_OBJECT

public:
    ~Database();

    static Database* instance();

public slots:
    bool addCategory(const QString &name, const QString &path);
    bool removeCategory(const QString &name);
    QString getCategoryPath(const QString &name);
    QList< QPair<QString, QString> > getCategories();
    QStringList getCategoryNames();

    bool addAccount(const QString &serviceName, const QString &username, const QString &password);
    bool removeAccount(const QString &serviceName);
    QPair<QString, QString> getAccount(const QString &serviceName);

    bool addArchivePassword(const QString &password);
    bool removeArchivePassword(const QString &password);
    QStringList getArchivePasswords();

private:
    Database();

    void initialize();

signals:
    void error(const QString &message);
    void categoriesChanged();
    void archivePasswordsChanged();

private:
    static Database *m_instance;

    QSqlDatabase m_database;
};

#endif // DATABASE_H
