#ifndef QMLUTILS_H
#define QMLUTILS_H

#include "../shared/utils.h"
#include <QObject>

class QmlUtils : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString versionNumber
               READ versionNumber
               CONSTANT)
public:
    explicit QmlUtils(QObject *parent = 0);
    Q_INVOKABLE QString durationFromSecs(int secs);
    Q_INVOKABLE QString durationFromMSecs(int msecs);
    Q_INVOKABLE QString fileSizeFromPath(const QString &filePath);
    Q_INVOKABLE QString fileSizeFromBytes(double bytes);
    Q_INVOKABLE QString dateFromSecs(qint64 secs, bool showTime = true);
    Q_INVOKABLE QString dateFromMSecs(qint64 msecs, bool showTime = true);
    Q_INVOKABLE qint64 currentDateTime();
    Q_INVOKABLE QString localDateTimeFromString(const QString &dateTimeString, Qt::DateFormat = Qt::ISODate);
    inline QString versionNumber() const { return VERSION_NUMBER; }
    Q_INVOKABLE QString readPrivacyPolicy();
};

#endif // QMLUTILS_H
