import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxoft.models 1.0
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolIcon {
            platformIconId: "toolbar-back"
            onClicked: pageStack.pop()
        }
    }

    ListView {
        id: view

        anchors.fill: parent
        model: PluginSettingsModel {
            id: settingsModel
        }
        header: TitleHeader {
            title: qsTr("Plugins")
        }
        delegate: PluginSettingsDelegate {
            id: delegate

            onClicked: {
                var page = ObjectCreator.createObject(Qt.resolvedUrl("PluginSettingsPage.qml"), pageStack);
                page.loadSettings(pluginName, pluginIcon, fileName);
                pageStack.push(page);
            }
        }
    }
}
