import QtQuick 1.1
import com.nokia.symbian 1.1

ListItem {
    id: root

    width: !parent ? implicitWidth : parent.width
    height: 80

    Image {
        id: icon

        anchors {
            left: parent.left
            leftMargin: 10
            verticalCenter: parent.verticalCenter
        }

        source: parent.ListView.view.model.isFolder(index) ? "image://theme/icon-m-toolbar-directory-white" : "image://theme/icon-m-toolbar-attachment-white"
    }

    Label {
        anchors {
            left: icon.right
            leftMargin: 10
            right: parent.right
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        elide: Text.ElideRight
        text: fileName
    }
}
