import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxoft.models 1.0

Page {
    id: root

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolIcon {
            platformIconId: "toolbar-back"
            onClicked: appWindow.pageStack.pop()
        }
    }

    ListView {
        id: view

        anchors.fill: parent
        model: SettingsModel {}
        header: TitleHeader {
            title: qsTr("Settings")
        }
        delegate: SettingsDelegate {
            onClicked: appWindow.pageStack.push(Qt.resolvedUrl(value))
        }
    }

    ScrollDecorator {
        flickableItem: view
    }
}
