import QtQuick 1.1
import com.marxoft.items 1.0

MaskedItem {
    id: root

    property alias iconSource: icon.source
    property bool interactive: false

    signal clicked

    width: 64
    height: 64
    opacity: mouseArea.pressed ? 0.5 : 1
    mask: Image {
        width: root.width
        height: root.height
        source: "qrc:/avatar-mask.png"
        fillMode: Image.Stretch
        smooth: true
    }

    Image {
        id: frame

        anchors.fill: parent
        source: "qrc:/avatar-frame.png"
        sourceSize.width: width
        sourceSize.height: height
        smooth: true
        fillMode: Image.Stretch
        visible: icon.status == Image.Ready

        Image {
            id: icon

            z: -1
            anchors.fill: parent
            sourceSize.width: width
            sourceSize.height: height
            smooth: true
            fillMode: Image.PreserveAspectCrop
            asynchronous: false
            clip: true
            onStatusChanged: if (status == Image.Error) source = "qrc:/qdlharmattan64.png";
        }
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        enabled: root.interactive
        onClicked: root.clicked()
    }
}
