import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    signal clicked

    width: parent.width
    height: 80

    Rectangle {
        id: highlight

        anchors {
            fill: parent
            topMargin: 1
            bottomMargin: 1
        }

        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        opacity: 0.5
        visible: mouseArea.pressed
    }

    Image {
        id: icon

        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }

        source: parent.ListView.view.model.isFolder(index) ? "image://theme/icon-m-toolbar-directory-white" : "image://theme/icon-m-toolbar-attachment-white"
    }

    Label {
        anchors {
            left: icon.right
            leftMargin: UI.PADDING_DOUBLE
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }

        font.bold: true
        elide: Text.ElideRight
        text: fileName
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: root.clicked()
    }
}
