import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

ListItem {
    id: root

    ServiceIcon {
        id: icon

        smooth: true
        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }

        iconSource: iconPath + serviceIcon
    }

    Label {
        anchors {
            top: icon.top
            left: icon.right
            leftMargin: UI.PADDING_DOUBLE
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
        }

        font.bold: true
        wrapMode: Text.NoWrap
        elide: Text.ElideRight
        text: serviceName
    }

    Label {
        anchors {
            bottom: parent.bottom
            left: icon.right
            leftMargin: UI.PADDING_DOUBLE
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
        }

        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        wrapMode: Text.NoWrap
        elide: Text.ElideRight
        text: username === "" ? qsTr("No account") : username
    }
}
