#include "session.h"
#include "networkaccessmanager.h"
#include "settings.h"
#include "database.h"
#include "storage.h"
#include "urlchecker.h"
#include "urlretriever.h"
#include "pluginmanager.h"
#include "clipboardmonitor.h"
#include "transfermodel.h"
#include <QThread>

Session::Session(QObject *parent) :
    QObject(parent),
    m_nam(NetworkAccessManager::instance()),
    m_settings(Settings::instance()),
    m_database(Database::instance()),
    m_storage(Storage::instance()),
    m_urlChecker(UrlChecker::instance()),
    m_urlRetriever(UrlRetriever::instance()),
    m_pluginManager(PluginManager::instance()),
    m_clipboardMonitor(ClipboardMonitor::instance()),
    m_model(TransferModel::instance()),
    m_thread(new QThread)
{
    m_nam->setParent(this);
    m_settings->setParent(this);
    m_urlChecker->setParent(this);
    m_urlRetriever->setParent(this);
    m_pluginManager->setParent(this);
    m_clipboardMonitor->setParent(this);
    m_model->setParent(this);

    m_database->moveToThread(m_thread);
    m_storage->moveToThread(m_thread);
    m_thread->start(QThread::LowPriority);

    this->connect(m_thread, SIGNAL(finished()), m_thread, SLOT(deleteLater()));
    this->connect(m_thread, SIGNAL(finished()), m_database, SLOT(deleteLater()));
    this->connect(m_thread, SIGNAL(finished()), m_storage, SLOT(deleteLater()));
}

Session::~Session() {
    m_thread->quit();
}
